/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import jakarta.inject.Inject;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.service.CassandraMappingsService;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class CassandraMappingsRoutes
implements Routes {
    public static final String ROOT_PATH = "cassandra/mappings";
    private static final TaskRegistrationKey SOLVE_INCONSISTENCIES = TaskRegistrationKey.of((String)"SolveInconsistencies");
    private final CassandraMappingsService cassandraMappingsService;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;

    @Inject
    CassandraMappingsRoutes(CassandraMappingsService cassandraMappingsService, TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.cassandraMappingsService = cassandraMappingsService;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.post(ROOT_PATH, this.performActionOnMappings(), (ResponseTransformer)this.jsonTransformer);
    }

    public Route performActionOnMappings() {
        return TaskFromRequestRegistry.of((TaskRegistrationKey)SOLVE_INCONSISTENCIES, request -> this.cassandraMappingsService.solveMappingsSourcesInconsistencies()).asRoute(this.taskManager);
    }
}

