/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;

public class UnionMailboxACLResolver
implements MailboxACLResolver {
    public static final MailboxACL DEFAULT_GLOBAL_USER_ACL = MailboxACL.OWNER_FULL_ACL;
    private static final int POSITIVE_INDEX = 0;
    private static final int NEGATIVE_INDEX = 1;
    private final MailboxACL userGlobalACL;

    public UnionMailboxACLResolver() {
        this.userGlobalACL = DEFAULT_GLOBAL_USER_ACL;
    }

    public UnionMailboxACLResolver(MailboxACL userGlobalACL, MailboxACL groupGlobalACL) {
        if (userGlobalACL == null) {
            throw new NullPointerException("Missing userGlobalACL.");
        }
        if (groupGlobalACL == null) {
            throw new NullPointerException("Missing groupGlobalACL.");
        }
        this.userGlobalACL = userGlobalACL;
    }

    protected static boolean applies(MailboxACL.EntryKey aclKey, MailboxACL.EntryKey queryKey, Username resourceOwner) {
        String aclKeyName = aclKey.getName();
        MailboxACL.NameType aclKeyNameType = aclKey.getNameType();
        if (MailboxACL.SpecialName.anyone.name().equals(aclKeyName)) {
            return true;
        }
        if (queryKey != null) {
            String queryUserOrGroupName = queryKey.getName();
            switch (queryKey.getNameType()) {
                case user: {
                    switch (aclKeyNameType) {
                        case special: {
                            if (MailboxACL.SpecialName.authenticated.name().equals(aclKeyName)) {
                                return true;
                            }
                            if (MailboxACL.SpecialName.owner.name().equals(aclKeyName)) {
                                return queryUserOrGroupName.equals(resourceOwner.asString());
                            }
                            throw new IllegalStateException("Unexpected " + MailboxACL.SpecialName.class.getName() + "." + aclKeyName);
                        }
                        case user: {
                            return aclKeyName.equals(queryUserOrGroupName);
                        }
                    }
                    throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + String.valueOf((Object)aclKeyNameType));
                }
                case group: {
                    switch (aclKeyNameType) {
                        case special: {
                            if (MailboxACL.SpecialName.authenticated.name().equals(aclKeyName)) {
                                return true;
                            }
                            if (MailboxACL.SpecialName.owner.name().equals(aclKeyName)) {
                                return false;
                            }
                            throw new IllegalStateException("Unexpected " + MailboxACL.SpecialName.class.getName() + "." + aclKeyName);
                        }
                        case user: {
                            return false;
                        }
                        case group: {
                            return aclKeyName.equals(queryUserOrGroupName);
                        }
                    }
                    throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + String.valueOf((Object)aclKeyNameType));
                }
                case special: {
                    switch (aclKeyNameType) {
                        case special: {
                            if (aclKeyName.equals(queryUserOrGroupName)) {
                                return true;
                            }
                            return MailboxACL.SpecialName.owner.name().equals(queryUserOrGroupName) && MailboxACL.SpecialName.authenticated.name().equals(aclKeyName);
                        }
                        case user: 
                        case group: {
                            return false;
                        }
                    }
                    throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + String.valueOf((Object)aclKeyNameType));
                }
            }
            throw new IllegalStateException("Unexpected " + MailboxACL.NameType.class.getName() + "." + String.valueOf((Object)queryKey.getNameType()));
        }
        return false;
    }

    @Override
    public MailboxACL applyGlobalACL(MailboxACL resourceACL) throws UnsupportedRightException {
        return resourceACL.union(this.userGlobalACL);
    }

    @Override
    public List<MailboxACL.Rfc4314Rights> listRights(MailboxACL.EntryKey queryKey, Username resourceOwner) throws UnsupportedRightException {
        MailboxACL.Rfc4314Rights[] positiveNegativePair = new MailboxACL.Rfc4314Rights[]{MailboxACL.NO_RIGHTS, MailboxACL.NO_RIGHTS};
        this.resolveRights(queryKey, this.userGlobalACL.getEntries(), resourceOwner, positiveNegativePair);
        if (queryKey.isNegative()) {
            return UnionMailboxACLResolver.toListRights(positiveNegativePair[1]);
        }
        return UnionMailboxACLResolver.toListRights(positiveNegativePair[0].except(positiveNegativePair[1]));
    }

    private static List<MailboxACL.Rfc4314Rights> toListRights(MailboxACL.Rfc4314Rights implicitRights) throws UnsupportedRightException {
        return (List)Stream.concat(MailboxACL.FULL_RIGHTS.list().stream().filter(Predicate.not(implicitRights::contains)).map(xva$0 -> new MailboxACL.Rfc4314Rights((MailboxACL.Right)((Object)xva$0))), Stream.of(implicitRights)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public MailboxACL.Rfc4314Rights resolveRights(Username requestUser, MailboxACL resourceACL, Username resourceOwner) throws UnsupportedRightException {
        MailboxACL.Rfc4314Rights[] positiveNegativePair = new MailboxACL.Rfc4314Rights[]{MailboxACL.NO_RIGHTS, MailboxACL.NO_RIGHTS};
        MailboxACL.EntryKey queryKey = requestUser == null ? null : MailboxACL.EntryKey.createUserEntryKey(requestUser);
        this.resolveRights(queryKey, this.userGlobalACL.getEntries(), resourceOwner, positiveNegativePair);
        if (resourceACL != null) {
            this.resolveRights(queryKey, resourceACL.getEntries(), resourceOwner, positiveNegativePair);
        }
        return positiveNegativePair[0].except(positiveNegativePair[1]);
    }

    private void resolveRights(MailboxACL.EntryKey queryKey, Map<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> entries, Username resourceOwner, MailboxACL.Rfc4314Rights[] positiveNegativePair) throws UnsupportedRightException {
        if (entries != null) {
            for (Map.Entry<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> entry : entries.entrySet()) {
                MailboxACL.EntryKey key = entry.getKey();
                if (!UnionMailboxACLResolver.applies(key, queryKey, resourceOwner)) continue;
                if (key.isNegative()) {
                    positiveNegativePair[1] = positiveNegativePair[1].union(entry.getValue());
                    continue;
                }
                positiveNegativePair[0] = positiveNegativePair[0].union(entry.getValue());
            }
        }
    }
}

