/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.imapserver.netty.IMAPServerFactory;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.utils.GuiceProbe;

public class ImapGuiceProbe
implements GuiceProbe {
    private final IMAPServerFactory imapServerFactory;

    @Inject
    private ImapGuiceProbe(IMAPServerFactory imapServerFactory) {
        this.imapServerFactory = imapServerFactory;
    }

    @PreDestroy
    void destroy() {
        this.imapServerFactory.destroy();
    }

    public int getImapPort() {
        return this.getPort(Predicate.not(AbstractConfigurableAsyncServer::getStartTLSSupported)).orElseThrow(() -> new IllegalStateException("IMAP server not defined"));
    }

    public int getImapStartTLSPort() {
        return this.getPort(AbstractConfigurableAsyncServer::getStartTLSSupported).orElseThrow(() -> new IllegalStateException("IMAPS server not defined"));
    }

    public int getImapSSLPort() {
        return this.getPort(server -> server.getSocketType().equals("secure")).orElseThrow(() -> new IllegalStateException("IMAPS server not defined"));
    }

    public Optional<Integer> getPort(Predicate<? super AbstractConfigurableAsyncServer> filter) {
        return this.imapServerFactory.getServers().stream().filter(filter).findFirst().flatMap(server -> server.getListenAddresses().stream().findFirst()).map(InetSocketAddress::getPort);
    }
}

