/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.KeepTypesMode;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class KeepTypesTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final KeepTypesMode mode;
    private final List<String> types;
    public static final JsonpDeserializer<KeepTypesTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeepTypesTokenFilter::setupKeepTypesTokenFilterDeserializer);

    private KeepTypesTokenFilter(Builder builder) {
        super(builder);
        this.mode = builder.mode;
        this.types = ApiTypeHelper.unmodifiable(builder.types);
    }

    public static KeepTypesTokenFilter of(Function<Builder, ObjectBuilder<KeepTypesTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.KeepTypes;
    }

    @Nullable
    public final KeepTypesMode mode() {
        return this.mode;
    }

    public final List<String> types() {
        return this.types;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keep_types");
        super.serializeInternal(generator, mapper);
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.types)) {
            generator.writeKey("types");
            generator.writeStartArray();
            for (String item0 : this.types) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupKeepTypesTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::mode, KeepTypesMode._DESERIALIZER, "mode");
        op.add(Builder::types, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "types");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeepTypesTokenFilter> {
        @Nullable
        private KeepTypesMode mode;
        @Nullable
        private List<String> types;

        public final Builder mode(@Nullable KeepTypesMode value) {
            this.mode = value;
            return this;
        }

        public final Builder types(List<String> list) {
            this.types = Builder._listAddAll(this.types, list);
            return this;
        }

        public final Builder types(String value, String ... values) {
            this.types = Builder._listAdd(this.types, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeepTypesTokenFilter build() {
            this._checkSingleUse();
            return new KeepTypesTokenFilter(this);
        }
    }
}

