/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class KeywordTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant,
ToCopyableBuilder<Builder, KeywordTokenizer> {
    private final int bufferSize;
    public static final JsonpDeserializer<KeywordTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeywordTokenizer::setupKeywordTokenizerDeserializer);

    private KeywordTokenizer(Builder builder) {
        super(builder);
        this.bufferSize = ApiTypeHelper.requireNonNull(builder.bufferSize, this, "bufferSize");
    }

    public static KeywordTokenizer of(Function<Builder, ObjectBuilder<KeywordTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.Keyword;
    }

    public final int bufferSize() {
        return this.bufferSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keyword");
        super.serializeInternal(generator, mapper);
        generator.writeKey("buffer_size");
        generator.write(this.bufferSize);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupKeywordTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        KeywordTokenizer.setupTokenizerBaseDeserializer(op);
        op.add(Builder::bufferSize, JsonpDeserializer.integerDeserializer(), "buffer_size");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Integer.hashCode(this.bufferSize);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeywordTokenizer other = (KeywordTokenizer)o;
        return this.bufferSize == other.bufferSize;
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, KeywordTokenizer> {
        private Integer bufferSize;

        public Builder() {
        }

        private Builder(KeywordTokenizer o) {
            super(o);
            this.bufferSize = o.bufferSize;
        }

        private Builder(Builder o) {
            super(o);
            this.bufferSize = o.bufferSize;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder bufferSize(int value) {
            this.bufferSize = value;
            return this;
        }

        @Override
        @Nonnull
        public KeywordTokenizer build() {
            this._checkSingleUse();
            return new KeywordTokenizer(this);
        }
    }
}

