/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.NumberPropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class ScaledFloatNumberProperty
extends NumberPropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Double nullValue;
    @Nullable
    private final Double scalingFactor;
    public static final JsonpDeserializer<ScaledFloatNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScaledFloatNumberProperty::setupScaledFloatNumberPropertyDeserializer);

    private ScaledFloatNumberProperty(Builder builder) {
        super(builder);
        this.coerce = builder.coerce;
        this.nullValue = builder.nullValue;
        this.scalingFactor = builder.scalingFactor;
    }

    public static ScaledFloatNumberProperty of(Function<Builder, ObjectBuilder<ScaledFloatNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.ScaledFloat;
    }

    @Nullable
    public final Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public final Double nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Double scalingFactor() {
        return this.scalingFactor;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "scaled_float");
        super.serializeInternal(generator, mapper);
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.doubleValue());
        }
        if (this.scalingFactor != null) {
            generator.writeKey("scaling_factor");
            generator.write(this.scalingFactor.doubleValue());
        }
    }

    protected static void setupScaledFloatNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        ScaledFloatNumberProperty.setupNumberPropertyBaseDeserializer(op);
        op.add(Builder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce");
        op.add(Builder::nullValue, JsonpDeserializer.doubleDeserializer(), "null_value");
        op.add(Builder::scalingFactor, JsonpDeserializer.doubleDeserializer(), "scaling_factor");
        op.ignore("type");
    }

    public static class Builder
    extends NumberPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScaledFloatNumberProperty> {
        @Nullable
        private Boolean coerce;
        @Nullable
        private Double nullValue;
        @Nullable
        private Double scalingFactor;

        public final Builder coerce(@Nullable Boolean value) {
            this.coerce = value;
            return this;
        }

        public final Builder nullValue(@Nullable Double value) {
            this.nullValue = value;
            return this;
        }

        public final Builder scalingFactor(@Nullable Double value) {
            this.scalingFactor = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScaledFloatNumberProperty build() {
            this._checkSingleUse();
            return new ScaledFloatNumberProperty(this);
        }
    }
}

