/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.PinnedDoc;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class PinnedQuery
extends QueryBase
implements TaggedUnion<Kind, Object>,
QueryVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final Query organic;
    public static final JsonpDeserializer<PinnedQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PinnedQuery::setupPinnedQueryDeserializer, Builder::build);

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Pinned;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private PinnedQuery(Builder builder) {
        super(builder);
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this.organic = ApiTypeHelper.requireNonNull(builder.organic, this, "organic");
    }

    public static PinnedQuery of(Function<Builder, ObjectBuilder<PinnedQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Query organic() {
        return this.organic;
    }

    public boolean isIds() {
        return this._kind == Kind.Ids;
    }

    public List<String> ids() {
        return (List)TaggedUnionUtils.get(this, Kind.Ids);
    }

    public boolean isDocs() {
        return this._kind == Kind.Docs;
    }

    public List<PinnedDoc> docs() {
        return (List)TaggedUnionUtils.get(this, Kind.Docs);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        super.serializeInternal(generator, mapper);
        generator.writeKey("organic");
        this.organic.serialize(generator, mapper);
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Ids: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Docs: {
                    generator.writeStartArray();
                    for (PinnedDoc item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return this.toBuilder(new Builder())._kind(this._kind)._value(this._value).organic(this.organic);
    }

    protected static void setupPinnedQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::organic, Query._DESERIALIZER, "organic");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(PinnedDoc._DESERIALIZER), "docs");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder> {
        private Kind _kind;
        private Object _value;
        private Query organic;

        public final Builder organic(Query value) {
            this.organic = value;
            return this;
        }

        public final Builder organic(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.organic(fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        protected final Builder _kind(Kind v) {
            this._kind = v;
            return this;
        }

        protected final Builder _value(Object v) {
            this._value = v;
            return this;
        }

        public ContainerBuilder ids(List<String> v) {
            this._kind = Kind.Ids;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder docs(List<PinnedDoc> v) {
            this._kind = Kind.Docs;
            this._value = v;
            return new ContainerBuilder();
        }

        protected PinnedQuery build() {
            this._checkSingleUse();
            return new PinnedQuery(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<PinnedQuery> {
            public final ContainerBuilder organic(Query value) {
                Builder.this.organic = value;
                return this;
            }

            public final ContainerBuilder organic(Function<Query.Builder, ObjectBuilder<Query>> fn) {
                return this.organic(fn.apply(new Query.Builder()).build());
            }

            @Override
            public PinnedQuery build() {
                return Builder.this.build();
            }
        }
    }

    public static enum Kind implements JsonEnum
    {
        Ids("ids"),
        Docs("docs");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

