/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.CountResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

public class CountRequest
extends CatRequestBase {
    private final List<String> index;
    public static final Endpoint<CountRequest, CountResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CountRequest, CountResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/count");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/count");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> new HashMap<String, String>(request.queryParameters()), SimpleEndpoint.emptyMap(), false, CountResponse._DESERIALIZER);

    private CountRequest(Builder builder) {
        super(builder);
        this.index = ApiTypeHelper.unmodifiable(builder.index);
    }

    public static CountRequest of(Function<Builder, ObjectBuilder<CountRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> index() {
        return this.index;
    }

    public static class Builder
    extends CatRequestBase.CatRequestBaseBuilder<Builder> {
        @Nullable
        private List<String> index;

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public CountRequest build() {
            this._checkSingleUse();
            return new CountRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

