/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ClusterNetworkTypes
implements PlainJsonSerializable {
    private final Map<String, Integer> httpTypes;
    private final Map<String, Integer> transportTypes;
    public static final JsonpDeserializer<ClusterNetworkTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterNetworkTypes::setupClusterNetworkTypesDeserializer);

    private ClusterNetworkTypes(Builder builder) {
        this.httpTypes = ApiTypeHelper.unmodifiableRequired(builder.httpTypes, (Object)this, "httpTypes");
        this.transportTypes = ApiTypeHelper.unmodifiableRequired(builder.transportTypes, (Object)this, "transportTypes");
    }

    public static ClusterNetworkTypes of(Function<Builder, ObjectBuilder<ClusterNetworkTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Integer> httpTypes() {
        return this.httpTypes;
    }

    public final Map<String, Integer> transportTypes() {
        return this.transportTypes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.httpTypes)) {
            generator.writeKey("http_types");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> item0 : this.httpTypes.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().intValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.transportTypes)) {
            generator.writeKey("transport_types");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> item0 : this.transportTypes.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().intValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupClusterNetworkTypesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::httpTypes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "http_types");
        op.add(Builder::transportTypes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "transport_types");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterNetworkTypes> {
        private Map<String, Integer> httpTypes;
        private Map<String, Integer> transportTypes;

        public final Builder httpTypes(Map<String, Integer> map) {
            this.httpTypes = Builder._mapPutAll(this.httpTypes, map);
            return this;
        }

        public final Builder httpTypes(String key, Integer value) {
            this.httpTypes = Builder._mapPut(this.httpTypes, key, value);
            return this;
        }

        public final Builder transportTypes(Map<String, Integer> map) {
            this.transportTypes = Builder._mapPutAll(this.transportTypes, map);
            return this;
        }

        public final Builder transportTypes(String key, Integer value) {
            this.transportTypes = Builder._mapPut(this.transportTypes, key, value);
            return this;
        }

        @Override
        public ClusterNetworkTypes build() {
            this._checkSingleUse();
            return new ClusterNetworkTypes(this);
        }
    }
}

