/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import java.util.List;
import java.util.Set;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.transaction.Mapper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface AnnotationMapper
extends Mapper {
    public List<MailboxAnnotation> getAllAnnotations(MailboxId var1);

    default public Publisher<MailboxAnnotation> getAllAnnotationsReactive(MailboxId mailboxId) {
        return Flux.fromIterable(this.getAllAnnotations(mailboxId)).subscribeOn(Schedulers.boundedElastic());
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxId var1, Set<MailboxAnnotationKey> var2);

    default public Publisher<MailboxAnnotation> getAnnotationsByKeysReactive(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return Flux.fromIterable(this.getAnnotationsByKeys(mailboxId, keys)).subscribeOn(Schedulers.boundedElastic());
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxId var1, Set<MailboxAnnotationKey> var2);

    default public Publisher<MailboxAnnotation> getAnnotationsByKeysWithOneDepthReactive(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return Flux.fromIterable(this.getAnnotationsByKeysWithOneDepth(mailboxId, keys)).subscribeOn(Schedulers.boundedElastic());
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxId var1, Set<MailboxAnnotationKey> var2);

    default public Publisher<MailboxAnnotation> getAnnotationsByKeysWithAllDepthReactive(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return Flux.fromIterable(this.getAnnotationsByKeysWithAllDepth(mailboxId, keys)).subscribeOn(Schedulers.boundedElastic());
    }

    public void deleteAnnotation(MailboxId var1, MailboxAnnotationKey var2);

    default public Publisher<Void> deleteAnnotationReactive(MailboxId mailboxId, MailboxAnnotationKey key) {
        return Mono.fromRunnable(() -> this.deleteAnnotation(mailboxId, key)).subscribeOn(Schedulers.boundedElastic()).then();
    }

    public void insertAnnotation(MailboxId var1, MailboxAnnotation var2);

    default public Publisher<Void> insertAnnotationReactive(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return Mono.fromRunnable(() -> this.insertAnnotation(mailboxId, mailboxAnnotation)).subscribeOn(Schedulers.boundedElastic()).then();
    }

    public boolean exist(MailboxId var1, MailboxAnnotation var2);

    default public Publisher<Boolean> existReactive(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return Mono.fromCallable(() -> this.exist(mailboxId, mailboxAnnotation)).subscribeOn(Schedulers.boundedElastic());
    }

    public int countAnnotations(MailboxId var1);

    default public Publisher<Integer> countAnnotationsReactive(MailboxId mailboxId) {
        return Mono.fromCallable(() -> this.countAnnotations(mailboxId)).subscribeOn(Schedulers.boundedElastic());
    }
}

