/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.comparator.AbstractHeaderComparator;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.field.DateTimeField;
import org.apache.james.mime4j.field.DateTimeFieldLenientImpl;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.util.OptionalUtils;
import org.apache.james.util.date.ImapDateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentDateComparator
extends AbstractHeaderComparator {
    public static final Comparator<MailboxMessage> SENTDATE = new SentDateComparator();
    private static final Logger LOGGER = LoggerFactory.getLogger(SentDateComparator.class);
    private static final Pattern DATE_SANITIZING_PATTERN = Pattern.compile(" *\\(.*\\) *");

    public static Optional<ZonedDateTime> toISODate(String value) {
        try {
            return Optional.of(ZonedDateTime.parse(SentDateComparator.sanitizeDateStringHeaderValue(value), ImapDateTimeFormatter.rfc5322()));
        }
        catch (Exception e) {
            return OptionalUtils.executeIfEmpty(Optional.ofNullable((DateTimeField)DateTimeFieldLenientImpl.PARSER.parse((Field)new RawField("Date", value), DecodeMonitor.SILENT)).flatMap(field -> Optional.ofNullable(field.getDate())).map(Date::toInstant).map(instant -> ZonedDateTime.ofInstant(instant, ZoneId.of("UTC"))), () -> LOGGER.info("Can not parse receive date {}", (Object)value));
        }
    }

    @VisibleForTesting
    static String sanitizeDateStringHeaderValue(String value) {
        Matcher sanitizerMatcher = DATE_SANITIZING_PATTERN.matcher(value);
        if (sanitizerMatcher.find()) {
            return StringUtils.normalizeSpace((String)value.substring(0, sanitizerMatcher.start()));
        }
        return StringUtils.normalizeSpace((String)value);
    }

    @Override
    public int compare(MailboxMessage o1, MailboxMessage o2) {
        return this.parseSentDate(o1).compareTo(this.parseSentDate(o2));
    }

    private Instant parseSentDate(MailboxMessage message) {
        String value = this.getHeaderValue("Date", message);
        RawField field = new RawField("Date", value);
        return Optional.ofNullable(((DateTimeField)DateTimeFieldLenientImpl.PARSER.parse((Field)field, DecodeMonitor.SILENT)).getDate()).map(Date::toInstant).orElse(message.getInternalDate().toInstant());
    }
}

