/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.r2dbc.postgresql.util.Assert;
import java.util.Arrays;
import java.util.Collection;

public class Vector {
    private static final Vector EMPTY = new Vector(new float[0]);
    private final float[] vec;

    private Vector(float[] vec) {
        this.vec = Assert.requireNonNull(vec, "Vector must not be null");
    }

    public static Vector empty() {
        return EMPTY;
    }

    public static Vector of(float ... vec) {
        Assert.requireNonNull(vec, "Vector must not be null");
        return vec.length == 0 ? Vector.empty() : new Vector(vec);
    }

    public static Vector of(Collection<? extends Number> vec) {
        Assert.requireNonNull(vec, "Vector must not be null");
        if (vec.isEmpty()) {
            return Vector.empty();
        }
        float[] floats = new float[vec.size()];
        int index = 0;
        for (Number number : vec) {
            Number next = Assert.requireNonNull(number, "Vector must not contain null elements");
            floats[index++] = next.floatValue();
        }
        return new Vector(floats);
    }

    public float[] getVector() {
        if (this.vec.length == 0) {
            return this.vec;
        }
        float[] copy = new float[this.vec.length];
        System.arraycopy(this.vec, 0, copy, 0, this.vec.length);
        return copy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector other = (Vector)o;
        return Arrays.equals(this.vec, other.vec);
    }

    public int hashCode() {
        return Arrays.hashCode(this.vec);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (int i = 0; i < this.vec.length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.vec[i]);
        }
        builder.append(']');
        return builder.toString();
    }
}

