/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIdTable;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIds;
import org.apache.james.mailbox.cassandra.table.CassandraThreadTable;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import reactor.core.publisher.Flux;

public class CassandraThreadDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertOne;
    private final PreparedStatement selectOne;
    private final PreparedStatement deleteOne;

    @Inject
    public CassandraThreadDAO(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertOne = session.prepare(QueryBuilder.insertInto((String)"thread_2").value(CassandraThreadTable.USERNAME, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraThreadTable.USERNAME)).value(CassandraThreadTable.MIME_MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraThreadTable.MIME_MESSAGE_ID)).value(CassandraMessageIds.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)).value(CassandraMessageIdTable.THREAD_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIdTable.THREAD_ID)).value(CassandraThreadTable.BASE_SUBJECT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraThreadTable.BASE_SUBJECT)).build());
        this.selectOne = session.prepare(((Select)QueryBuilder.selectFrom((String)"thread_2").columns(new CqlIdentifier[]{CassandraThreadTable.BASE_SUBJECT, CassandraMessageIdTable.THREAD_ID}).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraThreadTable.USERNAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraThreadTable.USERNAME)), (Relation)Relation.column((CqlIdentifier)CassandraThreadTable.MIME_MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraThreadTable.MIME_MESSAGE_ID))})).build());
        this.deleteOne = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"thread_2").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraThreadTable.USERNAME).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraThreadTable.USERNAME)), (Relation)Relation.column((CqlIdentifier)CassandraThreadTable.MIME_MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraThreadTable.MIME_MESSAGE_ID))})).build());
    }

    public Flux<Void> insertSome(Username username, Set<Integer> hashMimeMessageIds, MessageId messageId, ThreadId threadId, Optional<Integer> hashBaseSubject) {
        return Flux.fromIterable(hashMimeMessageIds).flatMap(mimeMessageId -> this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertOne.bind(new Object[0]).set(CassandraThreadTable.USERNAME, (Object)username.asString(), TypeCodecs.TEXT)).set(CassandraThreadTable.MIME_MESSAGE_ID, mimeMessageId, (TypeCodec)TypeCodecs.INT)).set(CassandraMessageIds.MESSAGE_ID, (Object)((CassandraMessageId)messageId).get(), TypeCodecs.TIMEUUID)).set(CassandraMessageIdTable.THREAD_ID, (Object)((CassandraMessageId)threadId.getBaseMessageId()).get(), TypeCodecs.TIMEUUID)).set(CassandraThreadTable.BASE_SUBJECT, (Object)hashBaseSubject.orElse(null), (TypeCodec)TypeCodecs.INT)), 16);
    }

    public Flux<Pair<Optional<Integer>, ThreadId>> selectSome(Username username, Set<Integer> hashMimeMessageIds) {
        return Flux.fromIterable(hashMimeMessageIds).flatMap(mimeMessageId -> this.executor.executeSingleRow((Statement)((BoundStatement)this.selectOne.bind(new Object[0]).set(CassandraThreadTable.USERNAME, (Object)username.asString(), TypeCodecs.TEXT)).set(CassandraThreadTable.MIME_MESSAGE_ID, mimeMessageId, (TypeCodec)TypeCodecs.INT)).map(this::readRow), 16).distinct();
    }

    public Flux<Void> deleteSome(Username username, Set<Integer> hashMimeMessageIds) {
        return Flux.fromIterable(hashMimeMessageIds).flatMap(mimeMessageId -> this.executor.executeVoid((Statement)((BoundStatement)this.deleteOne.bind(new Object[0]).set(CassandraThreadTable.USERNAME, (Object)username.asString(), TypeCodecs.TEXT)).set(CassandraThreadTable.MIME_MESSAGE_ID, mimeMessageId, (TypeCodec)TypeCodecs.INT)));
    }

    public Pair<Optional<Integer>, ThreadId> readRow(Row row) {
        return Pair.of(Optional.ofNullable((Integer)row.get(CassandraThreadTable.BASE_SUBJECT, Integer.class)), (Object)ThreadId.fromBaseMessageId((MessageId)CassandraMessageId.Factory.of(row.getUuid(CassandraMessageIdTable.THREAD_ID))));
    }
}

