/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.data;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.base.Predicate;
import com.datastax.oss.driver.shaded.guava.common.base.Predicates;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class CqlVector<T>
implements Iterable<T>,
Serializable {
    private final List<T> list;

    public static <V> CqlVector<V> newInstance(V ... vals) {
        return new CqlVector<V>(Arrays.asList(vals));
    }

    public static <V> CqlVector<V> newInstance(List<V> list) {
        Preconditions.checkArgument((list != null ? 1 : 0) != 0, (Object)"Input list should not be null");
        return new CqlVector<V>(list);
    }

    public static <V> CqlVector<V> from(@NonNull String str, @NonNull TypeCodec<V> subtypeCodec) {
        Preconditions.checkArgument((str != null ? 1 : 0) != 0, (Object)"Cannot create CqlVector from null string");
        Preconditions.checkArgument((!str.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create CqlVector from empty string");
        if (str.equalsIgnoreCase("NULL")) {
            return null;
        }
        int idx = ParseUtils.skipSpaces(str, 0);
        if (str.charAt(idx++) != '[') {
            throw new IllegalArgumentException(String.format("Cannot parse vector value from \"%s\", at character %d expecting '[' but got '%c'", str, idx, Character.valueOf(str.charAt(idx))));
        }
        if (str.charAt(idx = ParseUtils.skipSpaces(str, idx)) == ']') {
            return new CqlVector(new ArrayList());
        }
        ArrayList<V> list = new ArrayList<V>();
        while (idx < str.length()) {
            int n;
            try {
                n = ParseUtils.skipCQLValue(str, idx);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Cannot parse vector value from \"%s\", invalid CQL value at character %d", str, idx), e);
            }
            list.add(subtypeCodec.parse(str.substring(idx, n)));
            idx = n;
            idx = ParseUtils.skipSpaces(str, idx);
            if (str.charAt(idx) == ']') {
                return new CqlVector(list);
            }
            if (str.charAt(idx++) != ',') {
                throw new IllegalArgumentException(String.format("Cannot parse vector value from \"%s\", at character %d expecting ',' but got '%c'", str, idx, Character.valueOf(str.charAt(idx))));
            }
            idx = ParseUtils.skipSpaces(str, idx);
        }
        throw new IllegalArgumentException(String.format("Malformed vector value \"%s\", missing closing ']'", str));
    }

    private CqlVector(@NonNull List<T> list) {
        Preconditions.checkArgument((boolean)Iterables.all(list, (Predicate)Predicates.notNull()), (Object)"CqlVectors cannot contain null values");
        this.list = list;
    }

    public T get(int idx) {
        return this.list.get(idx);
    }

    public T set(int idx, T val) {
        return this.list.set(idx, val);
    }

    public int size() {
        return this.list.size();
    }

    public CqlVector<T> subVector(int from, int to) {
        return new CqlVector<T>(this.list.subList(from, to));
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public Stream<T> stream() {
        return this.list.stream();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CqlVector) {
            CqlVector that = (CqlVector)o;
            return this.list.equals(that.list);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.list);
    }

    public String toString() {
        return Iterables.toString(this.list);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private transient List<T> list;

        SerializationProxy(CqlVector<T> vector) {
            this.list = ((CqlVector)vector).list;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            int size = stream.readInt();
            this.list = new ArrayList<T>();
            for (int i = 0; i < size; ++i) {
                this.list.add(stream.readObject());
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return new CqlVector(this.list);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeInt(this.list.size());
            for (T item : this.list) {
                stream.writeObject(item);
            }
        }
    }
}

