/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedTokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.RandomTokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactoryRegistry;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultTokenFactoryRegistry
implements TokenFactoryRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTokenFactoryRegistry.class);
    private final String logPrefix;

    public DefaultTokenFactoryRegistry(InternalDriverContext context) {
        this.logPrefix = context.getSessionName();
    }

    @Override
    public TokenFactory tokenFactoryFor(String partitioner) {
        if ("org.apache.cassandra.dht.Murmur3Partitioner".equals(partitioner)) {
            LOG.debug("[{}] Detected Murmur3 partitioner ({})", (Object)this.logPrefix, (Object)partitioner);
            return new Murmur3TokenFactory();
        }
        if ("org.apache.cassandra.dht.RandomPartitioner".equals(partitioner)) {
            LOG.debug("[{}] Detected random partitioner ({})", (Object)this.logPrefix, (Object)partitioner);
            return new RandomTokenFactory();
        }
        if ("org.apache.cassandra.dht.ByteOrderedPartitioner".equals(partitioner)) {
            LOG.debug("[{}] Detected byte ordered partitioner ({})", (Object)this.logPrefix, (Object)partitioner);
            return new ByteOrderedTokenFactory();
        }
        LOG.warn("[{}] Unsupported partitioner '{}', token map will be empty.", (Object)this.logPrefix, (Object)partitioner);
        return null;
    }
}

