/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import net.jcip.annotations.Immutable;

@Immutable
public class RandomToken
implements Token {
    private final BigInteger value;

    public RandomToken(BigInteger value) {
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RandomToken) {
            RandomToken that = (RandomToken)other;
            return this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(@NonNull Token other) {
        Preconditions.checkArgument((boolean)(other instanceof RandomToken), (Object)"Can only compare tokens of the same type");
        RandomToken that = (RandomToken)other;
        return this.value.compareTo(that.getValue());
    }

    public String toString() {
        return "RandomToken(" + this.value + ")";
    }
}

