/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.response.result;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;

public class DsePreparedSubCodec
extends Result.SubCodec {
    public DsePreparedSubCodec(int protocolVersion) {
        super(4, protocolVersion);
        assert (protocolVersion >= 65);
    }

    @Override
    public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
        Prepared prepared = (Prepared)message;
        encoder.writeShortBytes(prepared.preparedQueryId, dest);
        if (this.protocolVersion >= 66) {
            encoder.writeShortBytes(prepared.resultMetadataId, dest);
        }
        prepared.variablesMetadata.encode(dest, encoder, true, this.protocolVersion);
        prepared.resultMetadata.encode(dest, encoder, false, this.protocolVersion);
    }

    @Override
    public int encodedSize(Message message) {
        Prepared prepared = (Prepared)message;
        int size = PrimitiveSizes.sizeOfShortBytes(prepared.preparedQueryId);
        if (this.protocolVersion >= 66) {
            assert (prepared.resultMetadataId != null);
            size += PrimitiveSizes.sizeOfShortBytes(prepared.resultMetadataId);
        }
        size += prepared.variablesMetadata.encodedSize(true, this.protocolVersion);
        return size += prepared.resultMetadata.encodedSize(false, this.protocolVersion);
    }

    @Override
    public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
        byte[] preparedQueryId = decoder.readShortBytes(source);
        byte[] resultMetadataId = this.protocolVersion >= 66 ? decoder.readShortBytes(source) : null;
        RowsMetadata variablesMetadata = RowsMetadata.decode(source, decoder, true, this.protocolVersion);
        RowsMetadata resultMetadata = RowsMetadata.decode(source, decoder, false, this.protocolVersion);
        return new Prepared(preparedQueryId, resultMetadataId, variablesMetadata, resultMetadata);
    }
}

