/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.event;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.BusLogging;
import org.apache.pekko.event.DiagnosticLoggingAdapter;
import org.apache.pekko.event.DiagnosticMarkerBusLoggingAdapter;
import org.apache.pekko.event.LogSource;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$Error$NoCause$;
import org.apache.pekko.event.Logging$LoggerInitialized$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.LoggingBus;
import org.apache.pekko.event.MarkerLoggingAdapter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NoStackTrace;

public final class Logging$ {
    public static final Logging$ MODULE$ = new Logging$();
    private static final int ErrorLevel = 1;
    private static final int WarningLevel = 2;
    private static final int InfoLevel = 3;
    private static final int DebugLevel = 4;
    @InternalApi
    private static final int OffLevel = Integer.MIN_VALUE;
    private static final Seq<Logging.LogLevel> AllLogLevels = (Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Logging.LogLevel[]{new Logging.LogLevel(MODULE$.ErrorLevel()), new Logging.LogLevel(MODULE$.WarningLevel()), new Logging.LogLevel(MODULE$.InfoLevel()), new Logging.LogLevel(MODULE$.DebugLevel())}));
    private static final Logging.SerializedStandardOutLogger org$apache$pekko$event$Logging$$serializedStandardOutLogger = new Logging.SerializedStandardOutLogger();
    private static final Logging.StandardOutLogger StandardOutLogger = new Logging.StandardOutLogger();
    private static final Map<String, Object> emptyMDC = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);

    public String simpleName(Object obj) {
        return this.simpleName(obj.getClass());
    }

    public String simpleName(Class<?> clazz) {
        String n = clazz.getName();
        int i = n.lastIndexOf(46);
        return n.substring(i + 1);
    }

    public String messageClassName(Object message) {
        if (message == null) {
            return "null";
        }
        if (message instanceof ActorSelectionMessage) {
            Object m = ((ActorSelectionMessage)message).msg();
            return new StringBuilder(23).append("ActorSelectionMessage(").append(m.getClass().getName()).append(")").toString();
        }
        return message.getClass().getName();
    }

    public final int ErrorLevel() {
        return ErrorLevel;
    }

    public final int WarningLevel() {
        return WarningLevel;
    }

    public final int InfoLevel() {
        return InfoLevel;
    }

    public final int DebugLevel() {
        return DebugLevel;
    }

    public final int OffLevel() {
        return OffLevel;
    }

    public Option<Logging.LogLevel> levelFor(String s) {
        String string = s.toLowerCase(Locale.ROOT);
        switch (string == null ? 0 : string.hashCode()) {
            case 109935: {
                if (!"off".equals(string)) break;
                return new Some((Object)new Logging.LogLevel(this.OffLevel()));
            }
            case 3237038: {
                if (!"info".equals(string)) break;
                return new Some((Object)new Logging.LogLevel(this.InfoLevel()));
            }
            case 95458899: {
                if (!"debug".equals(string)) break;
                return new Some((Object)new Logging.LogLevel(this.DebugLevel()));
            }
            case 96784904: {
                if (!"error".equals(string)) break;
                return new Some((Object)new Logging.LogLevel(this.ErrorLevel()));
            }
            case 1124446108: {
                if (!"warning".equals(string)) break;
                return new Some((Object)new Logging.LogLevel(this.WarningLevel()));
            }
        }
        return None$.MODULE$;
    }

    public int levelFor(Class<? extends Logging.LogEvent> eventClass) {
        if (Logging.Error.class.isAssignableFrom(eventClass)) {
            return this.ErrorLevel();
        }
        if (Logging.Warning.class.isAssignableFrom(eventClass)) {
            return this.WarningLevel();
        }
        if (Logging.Info.class.isAssignableFrom(eventClass)) {
            return this.InfoLevel();
        }
        if (Logging.Debug.class.isAssignableFrom(eventClass)) {
            return this.DebugLevel();
        }
        return this.DebugLevel();
    }

    public Class<? extends Logging.LogEvent> classFor(int level) {
        if (this.ErrorLevel() == level) {
            return Logging.Error.class;
        }
        if (this.WarningLevel() == level) {
            return Logging.Warning.class;
        }
        if (this.InfoLevel() == level) {
            return Logging.Info.class;
        }
        if (this.DebugLevel() == level) {
            return Logging.Debug.class;
        }
        throw new IllegalArgumentException(new StringBuilder(24).append("Unsupported log level [").append(new Logging.LogLevel(level)).append("]").toString());
    }

    public Seq<Logging.LogLevel> AllLogLevels() {
        return AllLogLevels;
    }

    /*
     * WARNING - void declaration
     */
    public <T> LoggingAdapter apply(ActorSystem system, T logSource, LogSource<T> evidence$3) {
        void var6_6;
        void var5_5;
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$3);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        return new BusLogging(system.eventStream(), (String)var5_5, (Class<?>)var6_6, ((ExtendedActorSystem)system).logFilter());
    }

    /*
     * WARNING - void declaration
     */
    public <T> MarkerLoggingAdapter withMarker(ActorSystem system, T logSource, LogSource<T> evidence$4) {
        void var6_6;
        void var5_5;
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, system, evidence$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        return new MarkerLoggingAdapter(system.eventStream(), (String)var5_5, (Class<?>)var6_6, ((ExtendedActorSystem)system).logFilter());
    }

    /*
     * WARNING - void declaration
     */
    public <T> LoggingAdapter apply(LoggingBus bus, T logSource, LogSource<T> evidence$5) {
        void var6_6;
        void var5_5;
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$5);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        return new BusLogging(bus, (String)var5_5, (Class<?>)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    public <T> MarkerLoggingAdapter withMarker(LoggingBus bus, T logSource, LogSource<T> evidence$6) {
        void var6_6;
        void var5_5;
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, evidence$6);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        return new MarkerLoggingAdapter(bus, (String)var5_5, (Class<?>)var6_6);
    }

    /*
     * WARNING - void declaration
     */
    public DiagnosticLoggingAdapter apply(Actor logSource) {
        void var4_4;
        void var3_3;
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticLoggingAdapter(system, (String)var3_3, (Class)var4_4){
            private Map<String, Object> org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc;

            public Map<String, Object> mdc() {
                return DiagnosticLoggingAdapter.mdc$(this);
            }

            public void mdc(Map<String, Object> mdc) {
                DiagnosticLoggingAdapter.mdc$(this, mdc);
            }

            public java.util.Map<String, Object> getMDC() {
                return DiagnosticLoggingAdapter.getMDC$(this);
            }

            public void setMDC(java.util.Map<String, Object> jMdc) {
                DiagnosticLoggingAdapter.setMDC$(this, jMdc);
            }

            public void clearMDC() {
                DiagnosticLoggingAdapter.clearMDC$(this);
            }

            public Map<String, Object> org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc() {
                return this.org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc;
            }

            public void org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc_$eq(Map<String, Object> x$1) {
                this.org$apache$pekko$event$DiagnosticLoggingAdapter$$_mdc = x$1;
            }
            {
                DiagnosticLoggingAdapter.$init$(this);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public DiagnosticMarkerBusLoggingAdapter withMarker(Actor logSource) {
        void var4_4;
        void var3_3;
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.apply(logSource, LogSource$.MODULE$.fromActor());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        ExtendedActorSystem system = (ExtendedActorSystem)logSource.context().system();
        return new DiagnosticMarkerBusLoggingAdapter(system.eventStream(), (String)var3_3, (Class<?>)var4_4, system.logFilter());
    }

    /*
     * WARNING - void declaration
     */
    public LoggingAdapter getLogger(ActorSystem system, Object logSource) {
        void var5_5;
        void var4_4;
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource, system);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        return new BusLogging(system.eventStream(), (String)var4_4, (Class<?>)var5_5, ((ExtendedActorSystem)system).logFilter());
    }

    /*
     * WARNING - void declaration
     */
    public LoggingAdapter getLogger(LoggingBus bus, Object logSource) {
        void var5_5;
        void var4_4;
        Tuple2<String, Class<?>> tuple2 = LogSource$.MODULE$.fromAnyRef(logSource);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String str = (String)tuple2._1();
        Class clazz = (Class)tuple2._2();
        return new BusLogging(bus, (String)var4_4, (Class<?>)var5_5);
    }

    public DiagnosticLoggingAdapter getLogger(Actor logSource) {
        return this.apply(logSource);
    }

    public Logging$Error$NoCause$ noCause() {
        return Logging$Error$NoCause$.MODULE$;
    }

    public Logging$LoggerInitialized$ loggerInitialized() {
        return Logging$LoggerInitialized$.MODULE$;
    }

    public Logging.SerializedStandardOutLogger org$apache$pekko$event$Logging$$serializedStandardOutLogger() {
        return org$apache$pekko$event$Logging$$serializedStandardOutLogger;
    }

    public Logging.StandardOutLogger StandardOutLogger() {
        return StandardOutLogger;
    }

    public String stackTraceFor(Throwable e) {
        if (e == null ? true : Logging$Error$NoCause$.MODULE$.equals(e)) {
            return "";
        }
        if (e instanceof NoStackTrace) {
            return new StringBuilder(5).append(" (").append(e.getClass().getName()).append(": ").append(e.getMessage()).append(")").toString();
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.append('\n');
        e.printStackTrace(pw);
        return sw.toString();
    }

    public Map<String, Object> emptyMDC() {
        return emptyMDC;
    }

    private Logging$() {
    }
}

