/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.util;

import java.util.Collections;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.netty.ssl.DefaultSslEngineFactory;

public class PulsarHttpAsyncSslEngineFactory
extends DefaultSslEngineFactory {
    private final PulsarSslFactory pulsarSslFactory;
    private final String host;

    public PulsarHttpAsyncSslEngineFactory(PulsarSslFactory pulsarSslFactory, String host) {
        this.pulsarSslFactory = pulsarSslFactory;
        this.host = host;
    }

    @Override
    protected void configureSslEngine(SSLEngine sslEngine, AsyncHttpClientConfig config) {
        super.configureSslEngine(sslEngine, config);
        if (StringUtils.isNotBlank(this.host)) {
            SSLParameters parameters = sslEngine.getSSLParameters();
            parameters.setServerNames(Collections.singletonList(new SNIHostName(this.host)));
            sslEngine.setSSLParameters(parameters);
        }
    }

    @Override
    public SSLEngine newSslEngine(AsyncHttpClientConfig config, String peerHost, int peerPort) {
        SSLContext sslContext = this.pulsarSslFactory.getInternalSslContext();
        SSLEngine sslEngine = config.isDisableHttpsEndpointIdentificationAlgorithm() ? sslContext.createSSLEngine() : sslContext.createSSLEngine(this.domain(peerHost), peerPort);
        this.configureSslEngine(sslEngine, config);
        return sslEngine;
    }
}

