/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplicationSummaryReplica
implements Serializable {
    private static final long serialVersionUID = 5967001261856109688L;
    @Nullable
    private final Date oldestBacklogChangeDate;
    @Nullable
    private final Long ldapServerPort;
    @Nullable
    private final Long replicationBacklog;
    @Nullable
    private final Long peakUpdateRate;
    @Nullable
    private final Long recentUpdateRate;
    @Nullable
    private final String generationID;
    @Nullable
    private final String ldapServerAddress;
    @Nullable
    private final String replicaID;
    @Nullable
    private final String replicationServerID;
    @NotNull
    private final String stringRepresentation;

    public ReplicationSummaryReplica(@NotNull String value) {
        int slashPos;
        this.stringRepresentation = value;
        this.replicaID = ReplicationSummaryReplica.getElementValue(value, "replica-id");
        this.replicationServerID = ReplicationSummaryReplica.getElementValue(value, "connected-to");
        this.generationID = ReplicationSummaryReplica.getElementValue(value, "generation-id");
        String hostPort = ReplicationSummaryReplica.getElementValue(value, "ldap-server");
        if (hostPort == null) {
            this.ldapServerAddress = null;
            this.ldapServerPort = null;
        } else {
            Long p;
            String a;
            try {
                int colonPos = hostPort.indexOf(58);
                a = hostPort.substring(0, colonPos);
                p = Long.parseLong(hostPort.substring(colonPos + 1));
            }
            catch (Exception e) {
                Debug.debugException(e);
                a = null;
                p = null;
            }
            this.ldapServerAddress = a;
            this.ldapServerPort = p;
        }
        String replicationBacklogStr = ReplicationSummaryReplica.getElementValue(value, "replication-backlog");
        if (replicationBacklogStr == null) {
            replicationBacklogStr = ReplicationSummaryReplica.getElementValue(value, "missing-changes");
        }
        if (replicationBacklogStr == null) {
            this.replicationBacklog = null;
        } else {
            Long mc;
            try {
                mc = Long.parseLong(replicationBacklogStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                mc = null;
            }
            this.replicationBacklog = mc;
        }
        String rateStr = ReplicationSummaryReplica.getElementValue(value, "recent-update-rate");
        if (rateStr == null) {
            this.recentUpdateRate = null;
        } else {
            Long r;
            try {
                slashPos = rateStr.indexOf(47);
                r = Long.parseLong(rateStr.substring(0, slashPos));
            }
            catch (Exception e) {
                Debug.debugException(e);
                r = null;
            }
            this.recentUpdateRate = r;
        }
        rateStr = ReplicationSummaryReplica.getElementValue(value, "peak-update-rate");
        if (rateStr == null) {
            this.peakUpdateRate = null;
        } else {
            Long r;
            try {
                slashPos = rateStr.indexOf(47);
                r = Long.parseLong(rateStr.substring(0, slashPos));
            }
            catch (Exception e) {
                Debug.debugException(e);
                r = null;
            }
            this.peakUpdateRate = r;
        }
        String dateStr = ReplicationSummaryReplica.getElementValue(value, "age-of-oldest-backlog-change");
        if (dateStr == null) {
            dateStr = ReplicationSummaryReplica.getElementValue(value, "age-of-oldest-missing-change");
        }
        if (dateStr == null) {
            this.oldestBacklogChangeDate = null;
        } else {
            Date d;
            try {
                int spacePos = dateStr.indexOf(32);
                d = StaticUtils.decodeGeneralizedTime(dateStr.substring(0, spacePos));
            }
            catch (Exception e) {
                Debug.debugException(e);
                d = null;
            }
            this.oldestBacklogChangeDate = d;
        }
    }

    @Nullable
    private static String getElementValue(@NotNull String s, @NotNull String n) {
        String nPlusEQ = n + "=\"";
        int pos = s.indexOf(nPlusEQ);
        if (pos < 0) {
            return null;
        }
        int closePos = s.indexOf(34, pos += nPlusEQ.length());
        if (closePos <= pos) {
            return null;
        }
        return s.substring(pos, closePos);
    }

    @Nullable
    public String getReplicaID() {
        return this.replicaID;
    }

    @Nullable
    public String getLDAPServerAddress() {
        return this.ldapServerAddress;
    }

    @Nullable
    public Long getLDAPServerPort() {
        return this.ldapServerPort;
    }

    @Nullable
    public String getReplicationServerID() {
        return this.replicationServerID;
    }

    @Nullable
    public String getGenerationID() {
        return this.generationID;
    }

    @Nullable
    public Long getRecentUpdateRate() {
        return this.recentUpdateRate;
    }

    @Nullable
    public Long getPeakUpdateRate() {
        return this.peakUpdateRate;
    }

    @Deprecated
    @Nullable
    public Long getMissingChanges() {
        return this.getReplicationBacklog();
    }

    @Nullable
    public Long getReplicationBacklog() {
        return this.replicationBacklog;
    }

    @Deprecated
    @Nullable
    public Date getOldestMissingChangeDate() {
        return this.getOldestBacklogChangeDate();
    }

    @Nullable
    public Date getOldestBacklogChangeDate() {
        return this.oldestBacklogChangeDate;
    }

    @NotNull
    public String toString() {
        return this.stringRepresentation;
    }
}

