/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.Set;
import org.apache.james.imap.api.ConnectionCheck;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imapserver.netty.IMAPMDCContext;
import org.apache.james.protocols.api.CommandDetectionSession;
import org.apache.james.protocols.api.ProxyInformation;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class HAProxyMessageHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HAProxyMessageHandler.class);
    private static final AttributeKey<CommandDetectionSession> SESSION_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"ImapSession");
    public static final AttributeKey<ProxyInformation> PROXY_INFO = AttributeKey.valueOf((String)"proxyInfo");
    private final Set<ConnectionCheck> connectionChecks;

    public HAProxyMessageHandler(Set<ConnectionCheck> connectionChecks) {
        this.connectionChecks = connectionChecks;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HAProxyMessage) {
            this.handleHAProxyMessage(ctx, (HAProxyMessage)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHAProxyMessage(ChannelHandlerContext ctx, HAProxyMessage haproxyMsg) throws Exception {
        try {
            ChannelPipeline pipeline = ctx.pipeline();
            ImapSession imapSession = (ImapSession)pipeline.channel().attr(SESSION_ATTRIBUTE_KEY).get();
            if (haproxyMsg.proxiedProtocol().equals((Object)HAProxyProxiedProtocol.TCP4) || haproxyMsg.proxiedProtocol().equals((Object)HAProxyProxiedProtocol.TCP6)) {
                InetSocketAddress sourceIP = new InetSocketAddress(haproxyMsg.sourceAddress(), haproxyMsg.sourcePort());
                ctx.channel().attr(PROXY_INFO).set((Object)new ProxyInformation(sourceIP, new InetSocketAddress(haproxyMsg.destinationAddress(), haproxyMsg.destinationPort())));
                LOGGER.info("Connection from {} runs through {} proxy", (Object)haproxyMsg.sourceAddress(), (Object)haproxyMsg.destinationAddress());
                MDCBuilder boundMDC = IMAPMDCContext.boundMDC(ctx);
                this.performConnectionCheck(sourceIP);
                if (imapSession != null) {
                    imapSession.setAttribute("bound_MDC", (Object)boundMDC);
                }
            } else {
                throw new IllegalArgumentException("Only TCP4/TCP6 are supported when using PROXY protocol.");
            }
            super.channelReadComplete(ctx);
        }
        finally {
            haproxyMsg.release();
        }
    }

    private void performConnectionCheck(InetSocketAddress realClientIp) {
        if (!this.connectionChecks.isEmpty()) {
            Flux.fromIterable(this.connectionChecks).concatMap(connectionCheck -> connectionCheck.validate(realClientIp)).then().block();
        }
    }
}

