/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.kernel.Eq;
import cats.kernel.Eq$;
import io.circe.Json;
import io.circe.JsonBigDecimal;
import io.circe.JsonBiggerDecimal;
import io.circe.JsonDecimal;
import io.circe.JsonDouble;
import io.circe.JsonFloat;
import io.circe.JsonLong;
import io.circe.JsonNumber;
import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.BiggerDecimal$;
import java.io.Serializable;
import java.math.BigDecimal;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class JsonNumber$
implements Serializable {
    public static final JsonNumber$ MODULE$ = new JsonNumber$();
    private static final Json.JNumber[] jsonLongConstantPool = (Json.JNumber[])Array$.MODULE$.tabulate(256, (Function1 & Serializable)x -> JsonNumber$.$anonfun$jsonLongConstantPool$1(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Json.JNumber.class));
    private static final BigDecimal bigDecimalMinLong = new BigDecimal(Long.MIN_VALUE);
    private static final BigDecimal bigDecimalMaxLong = new BigDecimal(Long.MAX_VALUE);
    private static final Eq<JsonNumber> eqJsonNumber = Eq$.MODULE$.instance((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)JsonNumber$.$anonfun$eqJsonNumber$1(x0$1, x1$1)));

    public final Json.JNumber fromLong(long value) {
        long idx = value + 128L;
        if (idx >= 0L && idx < (long)jsonLongConstantPool.length) {
            return jsonLongConstantPool[(int)idx];
        }
        return new Json.JNumber(new JsonLong(value));
    }

    public final JsonNumber fromDecimalStringUnsafe(String value) {
        return new JsonDecimal(value);
    }

    public final JsonNumber fromIntegralStringUnsafe(String value) {
        if (!BiggerDecimal$.MODULE$.integralIsValidLong(value)) {
            return new JsonDecimal(value);
        }
        long longValue = Long.parseLong(value);
        if (value.charAt(0) == '-' && longValue == 0L) {
            return new JsonDecimal(value);
        }
        return this.fromLong(longValue).value();
    }

    public final Option<JsonNumber> fromString(String value) {
        BiggerDecimal result = BiggerDecimal$.MODULE$.parseBiggerDecimalUnsafe(value);
        if (result == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new JsonBiggerDecimal(result, value));
    }

    public boolean bigDecimalIsWhole(BigDecimal value) {
        return value.signum() == 0 || value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    public boolean bigDecimalIsValidLong(BigDecimal value) {
        return this.bigDecimalIsWhole(value) && value.compareTo(bigDecimalMinLong) >= 0 && value.compareTo(bigDecimalMaxLong) <= 0;
    }

    public final Eq<JsonNumber> eqJsonNumber() {
        return eqJsonNumber;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonNumber$.class);
    }

    public static final /* synthetic */ Json.JNumber $anonfun$jsonLongConstantPool$1(int x) {
        return new Json.JNumber(new JsonLong(x - 128));
    }

    public static final /* synthetic */ boolean $anonfun$eqJsonNumber$1(JsonNumber x0$1, JsonNumber x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            JsonNumber jsonNumber = (JsonNumber)tuple2._1();
            JsonNumber jsonNumber2 = (JsonNumber)tuple2._2();
            if (jsonNumber instanceof JsonLong) {
                JsonLong jsonLong = (JsonLong)jsonNumber;
                long x = jsonLong.value();
                if (jsonNumber2 instanceof JsonLong) {
                    JsonLong jsonLong2 = (JsonLong)jsonNumber2;
                    long y = jsonLong2.value();
                    return x == y;
                }
            }
        }
        if (tuple2 != null) {
            JsonNumber jsonNumber = (JsonNumber)tuple2._1();
            JsonNumber jsonNumber3 = (JsonNumber)tuple2._2();
            if (jsonNumber instanceof JsonDouble) {
                JsonDouble jsonDouble = (JsonDouble)jsonNumber;
                double x = jsonDouble.value();
                if (jsonNumber3 instanceof JsonDouble) {
                    JsonDouble jsonDouble2 = (JsonDouble)jsonNumber3;
                    double y = jsonDouble2.value();
                    return Double.compare(x, y) == 0;
                }
            }
        }
        if (tuple2 != null) {
            JsonNumber jsonNumber = (JsonNumber)tuple2._1();
            JsonNumber jsonNumber4 = (JsonNumber)tuple2._2();
            if (jsonNumber instanceof JsonFloat) {
                JsonFloat jsonFloat = (JsonFloat)jsonNumber;
                float x = jsonFloat.value();
                if (jsonNumber4 instanceof JsonFloat) {
                    JsonFloat jsonFloat2 = (JsonFloat)jsonNumber4;
                    float y = jsonFloat2.value();
                    return Float.compare(x, y) == 0;
                }
            }
        }
        if (tuple2 != null) {
            JsonNumber jsonNumber = (JsonNumber)tuple2._1();
            JsonNumber jsonNumber5 = (JsonNumber)tuple2._2();
            if (jsonNumber instanceof JsonBigDecimal) {
                JsonBigDecimal jsonBigDecimal = (JsonBigDecimal)jsonNumber;
                BigDecimal x = jsonBigDecimal.value();
                if (jsonNumber5 instanceof JsonBigDecimal) {
                    JsonBigDecimal jsonBigDecimal2 = (JsonBigDecimal)jsonNumber5;
                    BigDecimal y = jsonBigDecimal2.value();
                    return x.compareTo(y) == 0;
                }
            }
        }
        if (tuple2 != null) {
            JsonNumber a = (JsonNumber)tuple2._1();
            JsonNumber b = (JsonNumber)tuple2._2();
            BiggerDecimal biggerDecimal = a.toBiggerDecimal();
            BiggerDecimal biggerDecimal2 = b.toBiggerDecimal();
            return !(biggerDecimal != null ? !biggerDecimal.equals(biggerDecimal2) : biggerDecimal2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    private JsonNumber$() {
    }
}

