/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jooq.AggregateFilterStep;
import org.jooq.ArrayAggOrderByStep;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Fields;
import org.jooq.JSON;
import org.jooq.JSONArrayAggNullStep;
import org.jooq.JSONArrayAggOrderByStep;
import org.jooq.JSONArrayAggReturningStep;
import org.jooq.JSONArrayNullStep;
import org.jooq.JSONArrayReturningStep;
import org.jooq.JSONB;
import org.jooq.JSONEntry;
import org.jooq.JSONObjectNullStep;
import org.jooq.JSONObjectReturningStep;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Scope;
import org.jooq.Select;
import org.jooq.SelectJoinStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.XML;
import org.jooq.XMLAggOrderByStep;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractRow;
import org.jooq.impl.AliasedSelect;
import org.jooq.impl.DSL;
import org.jooq.impl.DerivedTable;
import org.jooq.impl.JSONArrayAgg;
import org.jooq.impl.JSONEntryImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.MultisetDataType;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.RowAsField;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;

final class Multiset<R extends Record>
extends AbstractField<Result<R>>
implements QOM.Multiset<R> {
    static final Set<SQLDialect> NO_SUPPORT_JSON_COMPARE = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_JSONB_COMPARE = SQLDialect.supportedBy(new SQLDialect[0]);
    static final Set<SQLDialect> NO_SUPPORT_XML_COMPARE = SQLDialect.supportedBy(SQLDialect.POSTGRES);
    static final Set<SQLDialect> FORCE_LIMIT_IN_DERIVED_TABLE = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.TRINO);
    final TableLike<R> table;
    final Select<R> select;

    Multiset(TableLike<R> table) {
        Select<R> select;
        if (table instanceof Select) {
            Select s = (Select)table;
            select = s;
        } else {
            select = DSL.selectFrom(table);
        }
        this(table, select);
    }

    private Multiset(TableLike<R> table, Select<R> select) {
        super(Names.N_MULTISET, new MultisetDataType((AbstractRow)((Object)DSL.row(select.getSelect())), select.getRecordType()));
        this.table = table;
        this.select = select;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONDITION))) {
            ctx.data().remove(Tools.BooleanDataKey.DATA_MULTISET_CONDITION);
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true, c -> this.accept0((Context<?>)c, true));
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONDITION, true);
        } else {
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true, c -> this.accept0((Context<?>)c, false));
        }
    }

    private final void accept0(Context<?> ctx, boolean multisetCondition) {
        block0 : switch (Tools.emulateMultiset(ctx.configuration())) {
            case JSON: {
                JSONArrayAggOrderByStep<JSON> order;
                List<Field<?>> fields = this.select.getSelect();
                Table<R> t = new AliasedSelect<R>(this.select, true, false, FORCE_LIMIT_IN_DERIVED_TABLE.contains((Object)ctx.dialect()), Tools.fieldNames(fields.size())).as(Names.N_T, (Name[])null);
                switch (ctx.family()) {
                    default: 
                }
                if (DerivedTable.NO_SUPPORT_CORRELATED_DERIVED_TABLE.contains((Object)ctx.dialect()) && Multiset.isSimple(this.select)) {
                    List<Field> l = Tools.map(this.select.getSelect(), f -> Tools.unalias(f));
                    JSONArrayAggNullStep<JSON> returning = Multiset.jsonArrayaggEmulation(ctx, DSL.row(l), true, this.select.$distinct()).orderBy(multisetCondition ? Tools.map(Tools.filter(l, f -> Tools.sortable(f)), f -> f.sortDefault()) : this.select.$orderBy());
                    Select<?> s = this.select.$select(Arrays.asList(DSL.coalesce(Multiset.returningClob(ctx, returning), Multiset.returningClob(ctx, DSL.jsonArray(new Field[0]))))).$distinct(false).$orderBy(Arrays.asList(new SortField[0]));
                    Tools.visitSubquery(ctx, s);
                    break;
                }
                JSONArrayAggNullStep<JSON> returning = order = Multiset.jsonArrayaggEmulation(ctx, t, true, false);
                if (multisetCondition) {
                    returning = order.orderBy(t.fields());
                }
                Select s = JSONArrayAgg.patchOracleArrayAggBug(ctx, DSL.select(DSL.coalesce(Multiset.returningClob(ctx, returning), Multiset.returningClob(ctx, DSL.jsonArray(new Field[0])))).from((TableLike<?>)t));
                if (multisetCondition && NO_SUPPORT_JSON_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(DSL.field(s).cast(SQLDataType.VARCHAR));
                    break;
                }
                Tools.visitSubquery(ctx, s);
                break;
            }
            case JSONB: {
                JSONArrayAggOrderByStep<JSONB> order;
                List<Field<?>> fields = this.select.getSelect();
                Table<R> t = new AliasedSelect<R>(this.select, true, false, FORCE_LIMIT_IN_DERIVED_TABLE.contains((Object)ctx.dialect()), Tools.fieldNames(fields.size())).as(Names.N_T, (Name[])null);
                switch (ctx.family()) {
                    default: 
                }
                if (DerivedTable.NO_SUPPORT_CORRELATED_DERIVED_TABLE.contains((Object)ctx.dialect()) && Multiset.isSimple(this.select)) {
                    List<Field> l = Tools.map(this.select.getSelect(), f -> Tools.unalias(f));
                    JSONArrayAggNullStep<JSONB> returning = Multiset.jsonbArrayaggEmulation(ctx, DSL.row(l), true, this.select.$distinct()).orderBy(multisetCondition ? Tools.map(Tools.filter(l, f -> Tools.sortable(f)), f -> f.sortDefault()) : this.select.$orderBy());
                    Select<?> s = this.select.$select(Arrays.asList(DSL.coalesce(Multiset.returningClob(ctx, returning), Multiset.returningClob(ctx, DSL.jsonbArray(new Field[0]))))).$distinct(false).$orderBy(Arrays.asList(new SortField[0]));
                    Tools.visitSubquery(ctx, s);
                    break;
                }
                JSONArrayAggNullStep<JSONB> returning = order = Multiset.jsonbArrayaggEmulation(ctx, t, false, false);
                if (multisetCondition) {
                    returning = order.orderBy(t.fields());
                }
                Select s = JSONArrayAgg.patchOracleArrayAggBug(ctx, DSL.select(DSL.coalesce(Multiset.returningClob(ctx, returning), Multiset.returningClob(ctx, DSL.jsonbArray(new Field[0])))).from((TableLike<?>)t));
                if (multisetCondition && NO_SUPPORT_JSONB_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(DSL.field(s).cast(SQLDataType.VARCHAR));
                    break;
                }
                Tools.visitSubquery(ctx, s);
                break;
            }
            case XML: {
                XMLAggOrderByStep<XML> order;
                List<Field<?>> fields = this.select.getSelect();
                Table<R> t = new AliasedSelect<R>(this.select, true, false, FORCE_LIMIT_IN_DERIVED_TABLE.contains((Object)ctx.dialect()), Tools.fieldNames(fields.size())).as(Names.N_T, (Name[])null);
                switch (ctx.family()) {
                    default: 
                }
                if (DerivedTable.NO_SUPPORT_CORRELATED_DERIVED_TABLE.contains((Object)ctx.dialect()) && Multiset.isSimple(this.select) && !this.select.$distinct()) {
                    List<Field> l = Tools.map(this.select.getSelect(), f -> Tools.unalias(f));
                    Multiset.acceptMultisetSubqueryForXMLEmulation(ctx, multisetCondition, this.select.$select(Arrays.asList(DSL.xmlelement(Multiset.nResult(ctx), Multiset.xmlaggEmulation(ctx, DSL.row(l), true).orderBy(multisetCondition ? Tools.map(Tools.filter(l, f -> Tools.sortable(f)), f -> f.sortDefault()) : this.select.$orderBy())))).$orderBy(Arrays.asList(new SortField[0])));
                    break;
                }
                AggregateFilterStep<XML> filter = order = Multiset.xmlaggEmulation(ctx, t, false);
                if (multisetCondition) {
                    filter = order.orderBy(t.fields());
                }
                Multiset.acceptMultisetSubqueryForXMLEmulation(ctx, multisetCondition, DSL.select(DSL.xmlelement(Multiset.nResult(ctx), filter)).from((TableLike<?>)t));
                break;
            }
            case NATIVE: {
                switch (ctx.family()) {
                    case DUCKDB: {
                        SelectJoinStep s = DSL.select(DSL.field(Names.N_T)).from((TableLike<?>)this.select.asTable(Names.N_T));
                        Tools.visitSubquery(ctx.visit(Keywords.K_ARRAY), multisetCondition ? s.orderBy(DSL.field(Names.N_T)) : s);
                        break block0;
                    }
                }
                Tools.visitSubquery(ctx.visit(Keywords.K_MULTISET), this.select);
            }
        }
    }

    private static final void acceptMultisetSubqueryForXMLEmulation(Context<?> ctx, boolean multisetCondition, Select<Record1<XML>> s) {
        if (multisetCondition && NO_SUPPORT_XML_COMPARE.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.xmlserializeContent(DSL.field(s), SQLDataType.VARCHAR));
        } else {
            Tools.visitSubquery(ctx, s);
        }
    }

    private static final boolean isSimple(Select<?> s) {
        return s.$groupBy().isEmpty() && s.$having() == null && s.$window().isEmpty() && s.$qualify() == null && !Tools.selectQueryImpl(s).hasUnions() && s.$offset() == null && s.$limit() == null;
    }

    static final Name nResult(Scope ctx) {
        switch (ctx.family()) {
            default: 
        }
        return Names.N_RESULT;
    }

    static final Name xsiNil(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        return DSL.name("xsi:nil");
    }

    static final <J> Field<J> returningClob(Scope ctx, JSONObjectReturningStep<J> j) {
        switch (ctx.family()) {
            default: 
        }
        return j;
    }

    static final <J> Field<J> returningClob(Scope ctx, JSONArrayReturningStep<J> j) {
        switch (ctx.family()) {
            default: 
        }
        return j;
    }

    static final <J> Field<J> returningClob(Scope ctx, JSONArrayAggReturningStep<J> j) {
        switch (ctx.family()) {
            default: 
        }
        return j;
    }

    static final JSONArrayAggOrderByStep<JSON> jsonArrayaggEmulation(Context<?> ctx, Fields fields, boolean agg, boolean distinct) {
        return Multiset.jsonxArrayaggEmulation(ctx, fields, agg, distinct ? DSL::jsonArrayAggDistinct : DSL::jsonArrayAgg, DSL::jsonObject, DSL::jsonArray);
    }

    static final JSONArrayAggOrderByStep<JSONB> jsonbArrayaggEmulation(Context<?> ctx, Fields fields, boolean agg, boolean distinct) {
        return Multiset.jsonxArrayaggEmulation(ctx, fields, agg, distinct ? DSL::jsonbArrayAggDistinct : DSL::jsonbArrayAgg, DSL::jsonbObject, DSL::jsonbArray);
    }

    static final <J> JSONArrayAggOrderByStep<J> jsonxArrayaggEmulation(Context<?> ctx, Fields fields, boolean agg, Function<? super Field<?>, ? extends JSONArrayAggOrderByStep<J>> jsonxArrayAgg, Function<? super Collection<? extends JSONEntry<?>>, ? extends JSONObjectNullStep<J>> jsonxObject, Function<? super Collection<? extends Field<?>>, ? extends JSONArrayNullStep<J>> jsonxArray) {
        switch (ctx.family()) {
            default: 
        }
        return jsonxArrayAgg.apply(Multiset.returningClob(ctx, jsonxArray.apply(Tools.map(fields.fields(), (f, i) -> JSONEntryImpl.unescapeNestedJSON(ctx, Multiset.castForJSON(ctx, agg ? f : DSL.field(Tools.fieldName(i), f.getDataType()))))).nullOnNull()));
    }

    static final Field<?> castForJSON(Context<?> ctx, Field<?> field) {
        DataType t = field.getDataType();
        if (t.isFloat()) {
            switch (ctx.family()) {
                case H2: {
                    return field.cast(SQLDataType.VARCHAR);
                }
            }
        }
        return field;
    }

    static final Field<?> castForXML(Context<?> ctx, Field<?> field) {
        return field;
    }

    static final XMLAggOrderByStep<XML> xmlaggEmulation(Context<?> ctx, Fields fields, boolean agg) {
        return DSL.xmlagg(DSL.xmlelement(Names.N_RECORD, Tools.map(fields.fields(), (f, i) -> {
            Field<?> v = Multiset.castForXML(ctx, agg ? f : DSL.field(Tools.fieldName(i), f.getDataType()));
            String n = Tools.fieldNameString(i);
            return Multiset.wrapXmlelement(ctx, v, n);
        })));
    }

    static final Field<XML> wrapXmlelement(Context<?> ctx, Field<?> v, String n) {
        DataType t = v.getDataType();
        if (t.isString() || t.isArray()) {
            return DSL.xmlelement(n, DSL.xmlattributes(new Field[]{DSL.when(v.isNull(), DSL.inline("true")).as(Multiset.xsiNil(ctx))}), v);
        }
        return DSL.xmlelement(n, v);
    }

    static final ArrayAggOrderByStep<?> arrayAggEmulation(Fields fields, boolean agg) {
        return DSL.arrayAgg(new RowAsField(DSL.row(Tools.map(fields.fields(), (f, i) -> agg ? f : DSL.field(Tools.fieldName(i), f.getDataType())))));
    }

    @Override
    public final TableLike<R> $table() {
        return this.table;
    }
}

