/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.apps.webpush;

import com.google.crypto.tink.HybridDecrypt;
import com.google.crypto.tink.apps.webpush.WebPushConstants;
import com.google.crypto.tink.apps.webpush.WebPushUtil;
import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class WebPushHybridDecrypt
implements HybridDecrypt {
    private final ECPrivateKey recipientPrivateKey;
    private final byte[] recipientPublicKey;
    private final byte[] authSecret;
    private final int recordSize;

    private WebPushHybridDecrypt(Builder builder) throws GeneralSecurityException {
        if (builder.recipientPrivateKey == null) {
            throw new IllegalArgumentException("must set recipient's private key with Builder.withRecipientPrivateKey");
        }
        this.recipientPrivateKey = builder.recipientPrivateKey;
        if (builder.recipientPublicKey == null || builder.recipientPublicKey.length != 65) {
            throw new IllegalArgumentException("recipient public key must have 65 bytes");
        }
        this.recipientPublicKey = builder.recipientPublicKey;
        if (builder.authSecret == null) {
            throw new IllegalArgumentException("must set auth secret with Builder.withAuthSecret");
        }
        if (builder.authSecret.length != 16) {
            throw new IllegalArgumentException("auth secret must have 16 bytes");
        }
        this.authSecret = builder.authSecret;
        if (builder.recordSize < 103 || builder.recordSize > 4096) {
            throw new IllegalArgumentException(String.format("invalid record size (%s); must be a number between [%s, %s]", builder.recordSize, 103, 4096));
        }
        this.recordSize = builder.recordSize;
    }

    public byte[] decrypt(byte[] ciphertext, byte[] contextInfo) throws GeneralSecurityException {
        if (contextInfo != null) {
            throw new GeneralSecurityException("contextInfo must be null because it is unused");
        }
        if (ciphertext.length < 103) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (ciphertext.length > 4096) {
            throw new GeneralSecurityException("ciphertext too long");
        }
        ByteBuffer record = ByteBuffer.wrap(ciphertext);
        byte[] salt = new byte[16];
        record.get(salt);
        int recordSize = record.getInt();
        if (recordSize != this.recordSize || recordSize < ciphertext.length || recordSize > 4096) {
            throw new GeneralSecurityException("invalid record size: " + recordSize);
        }
        byte publicKeySize = record.get();
        if (publicKeySize != 65) {
            throw new GeneralSecurityException("invalid ephemeral public key size: " + publicKeySize);
        }
        byte[] asPublicKey = new byte[65];
        record.get(asPublicKey);
        ECPoint asPublicPoint = EllipticCurves.pointDecode((EllipticCurves.CurveType)WebPushConstants.NIST_P256_CURVE_TYPE, (EllipticCurves.PointFormatType)WebPushConstants.UNCOMPRESSED_POINT_FORMAT, (byte[])asPublicKey);
        byte[] payload = new byte[ciphertext.length - 86];
        record.get(payload);
        byte[] ecdhSecret = EllipticCurves.computeSharedSecret((ECPrivateKey)this.recipientPrivateKey, (ECPoint)asPublicPoint);
        byte[] ikm = WebPushUtil.computeIkm(ecdhSecret, this.authSecret, this.recipientPublicKey, asPublicKey);
        byte[] cek = WebPushUtil.computeCek(ikm, salt);
        byte[] nonce = WebPushUtil.computeNonce(ikm, salt);
        return this.decrypt(cek, nonce, payload);
    }

    private byte[] decrypt(byte[] key, byte[] nonce, byte[] ciphertext) throws GeneralSecurityException {
        int index;
        Cipher cipher = (Cipher)EngineFactory.CIPHER.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec params = new GCMParameterSpec(128, nonce);
        cipher.init(2, (Key)new SecretKeySpec(key, "AES"), params);
        byte[] plaintext = cipher.doFinal(ciphertext);
        if (plaintext.length == 0) {
            throw new GeneralSecurityException("decryption failed");
        }
        for (index = plaintext.length - 1; index > 0 && plaintext[index] == 0; --index) {
        }
        if (plaintext[index] != 2) {
            throw new GeneralSecurityException("decryption failed");
        }
        return Arrays.copyOf(plaintext, index);
    }

    public static final class Builder {
        private ECPrivateKey recipientPrivateKey = null;
        private byte[] recipientPublicKey = null;
        private byte[] authSecret = null;
        private int recordSize = 4096;

        @CanIgnoreReturnValue
        public Builder withRecordSize(int val) {
            this.recordSize = val;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withAuthSecret(byte[] val) {
            this.authSecret = (byte[])val.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRecipientPublicKey(ECPublicKey val) throws GeneralSecurityException {
            this.recipientPublicKey = EllipticCurves.pointEncode((EllipticCurves.CurveType)WebPushConstants.NIST_P256_CURVE_TYPE, (EllipticCurves.PointFormatType)WebPushConstants.UNCOMPRESSED_POINT_FORMAT, (ECPoint)val.getW());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRecipientPublicKey(byte[] val) {
            this.recipientPublicKey = (byte[])val.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRecipientPrivateKey(ECPrivateKey val) throws GeneralSecurityException {
            this.recipientPrivateKey = val;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder withRecipientPrivateKey(byte[] val) throws GeneralSecurityException {
            this.recipientPrivateKey = EllipticCurves.getEcPrivateKey((EllipticCurves.CurveType)WebPushConstants.NIST_P256_CURVE_TYPE, (byte[])val);
            return this;
        }

        public WebPushHybridDecrypt build() throws GeneralSecurityException {
            return new WebPushHybridDecrypt(this);
        }
    }
}

