/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import jakarta.inject.Inject;
import java.util.Comparator;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.rrt.api.LoopDetectedException;
import org.apache.james.rrt.api.MappingAlreadyExistsException;
import org.apache.james.rrt.api.MappingConflictException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.api.SameSourceAndDestinationException;
import org.apache.james.rrt.api.SourceDomainIsNotInDomainListException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.AliasSourcesResponse;
import org.apache.james.webadmin.routes.MailAddressParser;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;
import spark.Spark;

public class AliasRoutes
implements Routes {
    public static final String ROOT_PATH = "address/aliases";
    private static final String ALIAS_DESTINATION_ADDRESS = "aliasDestinationAddress";
    private static final String ALIAS_ADDRESS_PATH = "address/aliases/:aliasDestinationAddress";
    private static final String ALIAS_SOURCE_ADDRESS = "aliasSourceAddress";
    private static final String USER_IN_ALIAS_SOURCES_ADDRESSES_PATH = "address/aliases/:aliasDestinationAddress/sources/:aliasSourceAddress";
    private static final String ADDRESS_TYPE = "alias";
    private final DomainList domainList;
    private final JsonTransformer jsonTransformer;
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    @VisibleForTesting
    AliasRoutes(RecipientRewriteTable recipientRewriteTable, DomainList domainList, JsonTransformer jsonTransformer) {
        this.domainList = domainList;
        this.jsonTransformer = jsonTransformer;
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        service.get(ROOT_PATH, this::listAddressesWithAliases, (ResponseTransformer)this.jsonTransformer);
        service.get(ALIAS_ADDRESS_PATH, this::listAliasesOfAddress, (ResponseTransformer)this.jsonTransformer);
        service.put(USER_IN_ALIAS_SOURCES_ADDRESSES_PATH, this::addAlias);
        service.delete(USER_IN_ALIAS_SOURCES_ADDRESSES_PATH, this::deleteAlias);
    }

    public ImmutableSet<String> listAddressesWithAliases(Request request, Response response) throws RecipientRewriteTableException {
        return (ImmutableSet)this.recipientRewriteTable.getMappingsForType(Mapping.Type.Alias).flatMap(mapping -> mapping.asMailAddress().stream()).map(MailAddress::asString).collect(ImmutableSortedSet.toImmutableSortedSet(String::compareTo));
    }

    public HaltException addAlias(Request request, Response response) throws Exception {
        MailAddress aliasSourceAddress = MailAddressParser.parseMailAddress(request.params(ALIAS_SOURCE_ADDRESS), ADDRESS_TYPE);
        MailAddress destinationAddress = MailAddressParser.parseMailAddress(request.params(ALIAS_DESTINATION_ADDRESS), ADDRESS_TYPE);
        this.ensureDomainIsSupported(destinationAddress.getDomain());
        MappingSource source = MappingSource.fromUser((Username)Username.fromMailAddress((MailAddress)aliasSourceAddress));
        this.addAlias(source, destinationAddress);
        return Spark.halt((int)204);
    }

    private void addAlias(MappingSource source, MailAddress aliasSourceAddress) throws RecipientRewriteTableException {
        try {
            this.recipientRewriteTable.addAliasMapping(source, aliasSourceAddress.asString());
        }
        catch (MappingAlreadyExistsException mappingAlreadyExistsException) {
        }
        catch (SameSourceAndDestinationException | SourceDomainIsNotInDomainListException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(e.getMessage()).haltError();
        }
        catch (LoopDetectedException | MappingConflictException e) {
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.WRONG_STATE).message(e.getMessage()).haltError();
        }
    }

    private void ensureDomainIsSupported(Domain domain) throws DomainListException {
        if (!this.domainList.containsDomain(domain)) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("Domain in the destination is not managed by the DomainList").haltError();
        }
    }

    public HaltException deleteAlias(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress destinationAddress = MailAddressParser.parseMailAddress(request.params(ALIAS_DESTINATION_ADDRESS), ADDRESS_TYPE);
        MailAddress aliasToBeRemoved = MailAddressParser.parseMailAddress(request.params(ALIAS_SOURCE_ADDRESS), ADDRESS_TYPE);
        MappingSource source = MappingSource.fromMailAddress((MailAddress)aliasToBeRemoved);
        this.recipientRewriteTable.removeAliasMapping(source, destinationAddress.asString());
        return Spark.halt((int)204);
    }

    public ImmutableSet<AliasSourcesResponse> listAliasesOfAddress(Request request, Response response) throws RecipientRewriteTableException {
        MailAddress destinationAddress = MailAddressParser.parseMailAddress(request.params(ALIAS_DESTINATION_ADDRESS), ADDRESS_TYPE);
        return (ImmutableSet)this.recipientRewriteTable.listSources(Mapping.alias((String)destinationAddress.asString())).sorted(Comparator.comparing(MappingSource::asMailAddressString)).map(AliasSourcesResponse::new).collect(ImmutableSet.toImmutableSet());
    }
}

