/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.jmap.Version;
import org.apache.james.util.Port;

public class JMAPConfiguration {
    public static JMAPConfiguration DEFAULT = JMAPConfiguration.builder().enable().build();
    private final boolean enabled;
    private final Optional<Port> port;
    private final boolean emailQueryViewEnabled;
    private final boolean userProvisioningEnabled;
    private final Version defaultVersion;
    private final Optional<Long> maximumSendSize;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    JMAPConfiguration(boolean enabled, Optional<Port> port, boolean emailQueryViewEnabled, boolean userProvisioningEnabled, Version defaultVersion, Optional<Long> maximumSendSize) {
        this.enabled = enabled;
        this.port = port;
        this.emailQueryViewEnabled = emailQueryViewEnabled;
        this.userProvisioningEnabled = userProvisioningEnabled;
        this.defaultVersion = defaultVersion;
        this.maximumSendSize = maximumSendSize;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<Port> getPort() {
        return this.port;
    }

    public boolean isEmailQueryViewEnabled() {
        return this.emailQueryViewEnabled;
    }

    public boolean isUserProvisioningEnabled() {
        return this.userProvisioningEnabled;
    }

    public Version getDefaultVersion() {
        return this.defaultVersion;
    }

    public Optional<Long> getMaximumSendSize() {
        return this.maximumSendSize;
    }

    public static class Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<Boolean> emailQueryViewEnabled = Optional.empty();
        private Optional<Boolean> userProvisioningEnabled = Optional.empty();
        private Optional<Port> port = Optional.empty();
        private Optional<Version> defaultVersion = Optional.empty();
        private Optional<Long> maximumSendSize = Optional.empty();

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(enabled);
            return this;
        }

        public Builder enable() {
            return this.enabled(true);
        }

        public Builder disable() {
            return this.enabled(false);
        }

        public Builder enableEmailQueryView(boolean enabled) {
            return this.enableEmailQueryView(Optional.of(enabled));
        }

        public Builder enableEmailQueryView(Optional<Boolean> enabled) {
            this.emailQueryViewEnabled = enabled;
            return this;
        }

        public Builder userProvisioningEnabled(boolean enabled) {
            return this.userProvisioningEnabled(Optional.of(enabled));
        }

        public Builder userProvisioningEnabled(Optional<Boolean> enabled) {
            this.userProvisioningEnabled = enabled;
            return this;
        }

        public Builder enableEmailQueryView() {
            return this.enableEmailQueryView(true);
        }

        public Builder disableEmailQueryView() {
            return this.enableEmailQueryView(false);
        }

        public Builder enableUserProvisioning() {
            return this.userProvisioningEnabled(true);
        }

        public Builder disableUserProvisioning() {
            return this.userProvisioningEnabled(false);
        }

        public Builder port(Port port) {
            this.port = Optional.of(port);
            return this;
        }

        public Builder defaultVersion(Version defaultVersion) {
            return this.defaultVersion(Optional.of(defaultVersion));
        }

        public Builder defaultVersion(Optional<Version> defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public Builder randomPort() {
            this.port = Optional.empty();
            return this;
        }

        public Builder maximumSendSize(Optional<Long> maximumSendSize) {
            this.maximumSendSize = maximumSendSize;
            return this;
        }

        public JMAPConfiguration build() {
            Preconditions.checkState((boolean)this.enabled.isPresent(), (Object)"You should specify if JMAP server should be started");
            return new JMAPConfiguration(this.enabled.get(), this.port, this.emailQueryViewEnabled.orElse(false), this.userProvisioningEnabled.orElse(true), this.defaultVersion.orElse(Version.RFC8621), this.maximumSendSize);
        }
    }
}

