/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prometheus.client.SampleNameFilter;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.common.TextFormat;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.james.webadmin.PublicRoutes;
import spark.Request;
import spark.Response;
import spark.Service;

public class MetricsRoutes
implements PublicRoutes {
    public static final String BASE = "/metrics";
    private final DropwizardExports dropwizardExports;

    @Inject
    public MetricsRoutes(MetricRegistry registry) {
        this.dropwizardExports = new DropwizardExports(registry);
    }

    public String getBasePath() {
        return BASE;
    }

    public void define(Service service) {
        service.get(BASE, this::getMetrics);
    }

    public Response getMetrics(Request request, Response response) throws IOException {
        Set<String> params = this.parse(request.raw());
        HttpServletResponse rawResponse = response.raw();
        rawResponse.setStatus(200);
        rawResponse.setContentType("text/plain; version=0.0.4; charset=utf-8");
        try (BufferedWriter writer = new BufferedWriter(rawResponse.getWriter());){
            SampleNameFilter nameFilter = new SampleNameFilter.Builder().nameMustBeEqualTo(params).build();
            TextFormat.write004((Writer)writer, Collections.enumeration((Collection)this.dropwizardExports.collect().stream().filter(e -> nameFilter.test(e.name)).collect(ImmutableList.toImmutableList())));
            ((Writer)writer).flush();
        }
        return response;
    }

    private Set<String> parse(HttpServletRequest req) {
        String[] includedParam = req.getParameterValues("name[]");
        return (Set)Optional.ofNullable(includedParam).map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
    }
}

