/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.query.AbstractDomainObject;
import org.apache.openjpa.persistence.query.AbstractPath;
import org.apache.openjpa.persistence.query.AliasContext;
import org.apache.openjpa.persistence.query.AllExpression;
import org.apache.openjpa.persistence.query.AnyExpression;
import org.apache.openjpa.persistence.query.CaseExpression;
import org.apache.openjpa.persistence.query.CaseExpressionImpl;
import org.apache.openjpa.persistence.query.CurrentTimeExpression;
import org.apache.openjpa.persistence.query.DomainObject;
import org.apache.openjpa.persistence.query.ExistsExpression;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.ExpressionImpl;
import org.apache.openjpa.persistence.query.FetchPath;
import org.apache.openjpa.persistence.query.JoinPath;
import org.apache.openjpa.persistence.query.LiteralExpression;
import org.apache.openjpa.persistence.query.NavigationPath;
import org.apache.openjpa.persistence.query.NewInstance;
import org.apache.openjpa.persistence.query.OperatorPath;
import org.apache.openjpa.persistence.query.OrderByItem;
import org.apache.openjpa.persistence.query.OrderableItem;
import org.apache.openjpa.persistence.query.ParameterExpression;
import org.apache.openjpa.persistence.query.PathExpression;
import org.apache.openjpa.persistence.query.Predicate;
import org.apache.openjpa.persistence.query.QueryBuilderImpl;
import org.apache.openjpa.persistence.query.QueryDefinition;
import org.apache.openjpa.persistence.query.RootPath;
import org.apache.openjpa.persistence.query.SelectItem;
import org.apache.openjpa.persistence.query.SomeExpression;
import org.apache.openjpa.persistence.query.Subquery;
import org.apache.openjpa.persistence.query.Visitable;

public class QueryDefinitionImpl
extends ExpressionImpl
implements QueryDefinition,
Expression {
    private static final long serialVersionUID = 1L;
    private final QueryBuilderImpl _builder;
    private List<AbstractDomainObject> _domains;
    private List<PathExpression> _groupBys;
    private List<OrderableItem> _orderBys;
    private List<SelectItem> _projections;
    private boolean _distinct;
    private Predicate _where;
    private Predicate _having;
    protected static Localizer _loc = Localizer.forPackage(QueryDefinitionImpl.class);

    protected QueryDefinitionImpl(QueryBuilderImpl builder) {
        this._builder = builder;
    }

    @Override
    public DomainObject addRoot(Class cls) {
        RootPath root = new RootPath(this, cls);
        this.addDomain(root);
        return root;
    }

    @Override
    public DomainObject addSubqueryRoot(PathExpression path) {
        int i;
        AbstractPath impl = (AbstractPath)path;
        LinkedList<AbstractPath> paths = impl.split();
        QueryDefinitionImpl owner = impl.getOwner();
        for (i = 0; i < paths.size() && owner.hasDomain(paths.get(i)); ++i) {
        }
        AbstractPath next = paths.get(i);
        DomainObject newRoot = new NavigationPath(this, next.getParent(), next.getLastSegment().toString());
        this.addDomain((AbstractDomainObject)newRoot);
        ++i;
        while (i < paths.size()) {
            next = paths.get(i);
            newRoot = newRoot.join(next.getLastSegment().toString());
            ++i;
        }
        return newRoot;
    }

    boolean hasDomain(PathExpression path) {
        return this._domains != null && this._domains.contains(path);
    }

    protected <T extends AbstractDomainObject> T addDomain(T path) {
        if (this._domains == null) {
            this._domains = new ArrayList<AbstractDomainObject>();
        }
        this._domains.add(path);
        return path;
    }

    @Override
    public Subquery all() {
        return new AllExpression(this);
    }

    @Override
    public Subquery any() {
        return new AnyExpression(this);
    }

    @Override
    public Expression coalesce(Expression ... exp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression coalesce(String ... exp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression coalesce(Date ... exp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression coalesce(Calendar ... exp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression currentDate() {
        return new CurrentTimeExpression(Date.class);
    }

    @Override
    public Expression currentTime() {
        return new CurrentTimeExpression(Time.class);
    }

    @Override
    public Expression currentTimestamp() {
        return new CurrentTimeExpression(Timestamp.class);
    }

    @Override
    public Predicate exists() {
        return new ExistsExpression(this);
    }

    @Override
    public CaseExpression generalCase() {
        return new CaseExpressionImpl();
    }

    @Override
    public QueryDefinition groupBy(PathExpression ... pathExprs) {
        if (this._groupBys == null) {
            this._groupBys = new ArrayList<PathExpression>();
        } else {
            this._groupBys.clear();
        }
        for (PathExpression e : pathExprs) {
            this._groupBys.add(e);
        }
        return this;
    }

    @Override
    public QueryDefinition groupBy(List<PathExpression> pathExprList) {
        if (this._groupBys == null) {
            this._groupBys = new ArrayList<PathExpression>();
        } else {
            this._groupBys.clear();
        }
        for (PathExpression e : pathExprList) {
            this._groupBys.add(e);
        }
        return this;
    }

    @Override
    public QueryDefinition having(Predicate predicate) {
        this._having = predicate;
        return this;
    }

    @Override
    public Expression literal(String s) {
        return new LiteralExpression(s);
    }

    @Override
    public Expression literal(Number n) {
        return new LiteralExpression(n);
    }

    @Override
    public Expression literal(boolean b) {
        return new LiteralExpression(b);
    }

    @Override
    public Expression literal(Calendar c) {
        return new LiteralExpression(c);
    }

    @Override
    public Expression literal(Date d) {
        return new LiteralExpression(d);
    }

    @Override
    public Expression literal(char c) {
        return new LiteralExpression(Character.valueOf(c));
    }

    @Override
    public Expression literal(Class cls) {
        return new LiteralExpression(cls);
    }

    @Override
    public Expression literal(Enum<?> e) {
        return new LiteralExpression(e);
    }

    @Override
    public Expression nullLiteral() {
        return new LiteralExpression(null);
    }

    @Override
    public SelectItem newInstance(Class cls, SelectItem ... args) {
        return new NewInstance(cls, args);
    }

    @Override
    public Expression nullif(Expression exp1, Expression exp2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression nullif(Number arg1, Number arg2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression nullif(String arg1, String arg2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression nullif(Date arg1, Date arg2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression nullif(Calendar arg1, Calendar arg2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression nullif(Class arg1, Class arg2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression nullif(Enum<?> arg1, Enum<?> arg2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryDefinition orderBy(OrderByItem ... orderByItems) {
        if (this._orderBys == null) {
            this._orderBys = new ArrayList<OrderableItem>();
        } else {
            this._orderBys.clear();
        }
        for (OrderByItem i : orderByItems) {
            if (i instanceof OrderableItem) {
                this._orderBys.add((OrderableItem)i);
                continue;
            }
            this._orderBys.add(new OrderableItem((ExpressionImpl)i));
        }
        return this;
    }

    @Override
    public QueryDefinition orderBy(List<OrderByItem> orderByItemList) {
        if (this._orderBys == null) {
            this._orderBys = new ArrayList<OrderableItem>();
        } else {
            this._orderBys.clear();
        }
        for (OrderByItem i : orderByItemList) {
            if (i instanceof OrderableItem) {
                this._orderBys.add((OrderableItem)i);
                continue;
            }
            this._orderBys.add(new OrderableItem((ExpressionImpl)i, null));
        }
        return this;
    }

    @Override
    public Expression param(String name) {
        return new ParameterExpression(name);
    }

    @Override
    public Predicate predicate(boolean b) {
        return null;
    }

    @Override
    public QueryDefinition select(SelectItem ... items) {
        return this.select(items == null ? null : Arrays.asList(items), false);
    }

    @Override
    public QueryDefinition select(List<SelectItem> items) {
        return this.select(items, false);
    }

    @Override
    public QueryDefinition selectDistinct(SelectItem ... items) {
        return this.select(items == null ? null : Arrays.asList(items), true);
    }

    @Override
    public QueryDefinition selectDistinct(List<SelectItem> items) {
        return this.select(items, true);
    }

    private QueryDefinition select(List<SelectItem> items, boolean isDistinct) {
        if (this._projections == null) {
            this._projections = new ArrayList<SelectItem>();
        } else {
            this._projections.clear();
        }
        this._distinct = isDistinct;
        for (SelectItem item : items) {
            this._projections.add(item);
        }
        return this;
    }

    @Override
    public CaseExpression simpleCase(Expression caseOperand) {
        return new CaseExpressionImpl(caseOperand);
    }

    @Override
    public CaseExpression simpleCase(Number caseOperand) {
        return new CaseExpressionImpl(caseOperand);
    }

    @Override
    public CaseExpression simpleCase(String caseOperand) {
        return new CaseExpressionImpl(caseOperand);
    }

    @Override
    public CaseExpression simpleCase(Date caseOperand) {
        return new CaseExpressionImpl(caseOperand);
    }

    @Override
    public CaseExpression simpleCase(Calendar caseOperand) {
        return new CaseExpressionImpl(caseOperand);
    }

    @Override
    public CaseExpression simpleCase(Class caseOperand) {
        return new CaseExpressionImpl(caseOperand);
    }

    @Override
    public CaseExpression simpleCase(Enum<?> caseOperand) {
        return new CaseExpressionImpl(caseOperand);
    }

    @Override
    public Subquery some() {
        return new SomeExpression(this);
    }

    @Override
    public QueryDefinition where(Predicate predicate) {
        this._where = predicate;
        return this;
    }

    private List<SelectItem> getProjections() {
        if (this._projections == null) {
            ArrayList<SelectItem> defaultProjection = new ArrayList<SelectItem>();
            defaultProjection.add(this._domains.get(0));
            return defaultProjection;
        }
        return this._projections;
    }

    @Override
    public String asExpression(AliasContext ctx) {
        ctx.push(this);
        StringBuilder buffer = new StringBuilder();
        this.registerDomains(ctx);
        String select = this._distinct ? "SELECT DISTINCT " : "SELECT ";
        this.fillBuffer(select, buffer, ctx, this.getProjections(), Visit.PROJECTION);
        this.fillBuffer(" FROM ", buffer, ctx, this._domains, Visit.JOINABLE);
        this.fillBuffer(" WHERE ", buffer, ctx, this._where);
        this.fillBuffer(" GROUP BY ", buffer, ctx, this._groupBys, Visit.EXPRESSION);
        this.fillBuffer(" HAVING ", buffer, ctx, this._having);
        this.fillBuffer(" ORDER BY ", buffer, ctx, this._orderBys, Visit.EXPRESSION);
        return buffer.toString();
    }

    @Override
    public String asProjection(AliasContext ctx) {
        return this.asExpression(ctx);
    }

    public void fillBuffer(String header, StringBuilder buffer, AliasContext ctx, List list, Visit visit) {
        if (list == null || list.isEmpty()) {
            return;
        }
        buffer.append(header);
        block5: for (int i = 0; i < list.size(); ++i) {
            Visitable v = (Visitable)list.get(i);
            switch (visit) {
                case PROJECTION: {
                    buffer.append(v.asProjection(ctx)).append(i != list.size() - 1 ? ", " : " ");
                    continue block5;
                }
                case EXPRESSION: {
                    buffer.append(v.asExpression(ctx)).append(i != list.size() - 1 ? ", " : " ");
                    continue block5;
                }
                case JOINABLE: {
                    buffer.append(i > 0 && v instanceof RootPath ? ", " : " ").append(v.asJoinable(ctx));
                }
            }
        }
    }

    public void fillBuffer(String header, StringBuilder buffer, AliasContext ctx, Predicate p) {
        if (p == null) {
            return;
        }
        Visitable v = (Visitable)((Object)p);
        buffer.append(header);
        buffer.append(v.asExpression(ctx));
    }

    private void registerDomains(AliasContext ctx) {
        if (this._domains != null) {
            Collections.sort(this._domains, new DomainSorter());
            for (AbstractDomainObject domain : this._domains) {
                ctx.setAlias(domain);
            }
        }
        if (this._orderBys != null) {
            for (OrderableItem o : this._orderBys) {
                ExpressionImpl e = o.getExpression();
                if (this._projections == null || !this._projections.contains(e)) continue;
                ctx.setAlias(e);
            }
        }
    }

    static class DomainSorter
    implements Comparator<AbstractDomainObject> {
        static List<Class> _order = Arrays.asList(RootPath.class, NavigationPath.class, OperatorPath.class, JoinPath.class, FetchPath.class);

        DomainSorter() {
        }

        @Override
        public int compare(AbstractDomainObject a, AbstractDomainObject b) {
            return _order.indexOf(a.getClass()) - _order.indexOf(b.getClass());
        }
    }

    private static enum Visit {
        PROJECTION,
        EXPRESSION,
        JOINABLE;

    }
}

