/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import com.google.common.base.Strings;
import jakarta.mail.internet.MimePart;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTypeCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentTypeCleaner.class);
    private static final Pattern REGEX = Pattern.compile("^[\\w\\-]+/[\\w\\-]+");
    private static final String HANDLER_CLASS_PROPERTY = "mail.mime.contenttypehandler";

    public static void initialize() {
        System.setProperty(HANDLER_CLASS_PROPERTY, ContentTypeCleaner.class.getName());
    }

    public static String cleanContentType(MimePart mimePart, String contentType) {
        if (Strings.isNullOrEmpty((String)contentType)) {
            return null;
        }
        if (REGEX.matcher(contentType).find()) {
            return contentType;
        }
        LOGGER.info("Can not parse Content-Type: " + contentType);
        return null;
    }
}

