/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.load.ExportAbstract;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.LoadError;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

class ColumnInfo {
    private ArrayList<String> vtiColumnNames = new ArrayList(1);
    private ArrayList<String> insertColumnNames = new ArrayList(1);
    private ArrayList<String> columnTypes = new ArrayList(1);
    private ArrayList<Integer> jdbcColumnTypes = new ArrayList(1);
    private int noOfColumns = 0;
    private ArrayList columnPositions;
    private boolean createolumnNames = true;
    private int expectedNumberOfCols;
    private Connection conn;
    private String tableName;
    private String schemaName;
    private String[] headerColumnNames;
    private HashMap<String, String> udtClassNames = new HashMap();

    public ColumnInfo(Connection connection, String string, String string2, String string3, String string4, String string5, String[] stringArray) throws SQLException {
        StringTokenizer stringTokenizer;
        this.conn = connection;
        this.headerColumnNames = stringArray;
        if (string == null) {
            string = ((EngineConnection)connection).getCurrentSchemaName();
        }
        this.schemaName = string;
        this.tableName = string2;
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken().trim();
                if (this.initializeColumnInfo(string6)) continue;
                if (this.tableExists()) {
                    throw LoadError.invalidColumnName(string6);
                }
                String string7 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
                throw LoadError.tableNotFound(string7);
            }
        } else if (!this.initializeColumnInfo(null)) {
            String string8 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
            throw LoadError.tableNotFound(string8);
        }
        if (string4 != null) {
            stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                String string9 = stringTokenizer.nextToken().trim();
                if ("\"".equals(string9.substring(0, 1))) {
                    n = this.readHeaders(string9.replace('\"', ' ').trim());
                    this.vtiColumnNames.add(string5 + n);
                } else {
                    this.vtiColumnNames.add(string5 + string9);
                    n = Integer.parseInt(string9);
                }
                if (n <= this.expectedNumberOfCols) continue;
                this.expectedNumberOfCols = n;
            }
        }
        if (this.vtiColumnNames.size() < 1) {
            for (int i = 1; i <= this.noOfColumns; ++i) {
                this.vtiColumnNames.add(string5 + i);
            }
            this.expectedNumberOfCols = this.noOfColumns;
        }
    }

    private int readHeaders(String string) throws SQLException {
        if (this.headerColumnNames != null) {
            for (int i = 0; i < this.headerColumnNames.length; ++i) {
                if (!this.headerColumnNames[i].equals(string)) continue;
                return i + 1;
            }
            throw PublicAPI.wrapStandardException((StandardException)StandardException.newException((String)"42XAU", (Object[])new Object[]{string}));
        }
        throw PublicAPI.wrapStandardException((StandardException)StandardException.newException((String)"42XAV", (Object[])new Object[0]));
    }

    private boolean initializeColumnInfo(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, this.schemaName, this.tableName, string);
        boolean bl = false;
        while (resultSet.next()) {
            String string2 = resultSet.getString(4);
            short s = resultSet.getShort(5);
            String string3 = resultSet.getString(6);
            int n = resultSet.getInt(7);
            int n2 = resultSet.getInt(9);
            int n3 = resultSet.getInt(10);
            bl = true;
            if (ColumnInfo.importExportSupportedType(s)) {
                this.insertColumnNames.add(string2);
                String string4 = string3 + this.getTypeOption(string3, n, n, n2);
                this.columnTypes.add(string4);
                this.jdbcColumnTypes.add(Integer.valueOf(s));
                ++this.noOfColumns;
                if (s != 2000) continue;
                this.udtClassNames.put("COLUMN" + this.noOfColumns, this.getUDTClassName(databaseMetaData, string3));
                continue;
            }
            resultSet.close();
            throw LoadError.nonSupportedTypeColumn(string2, string3);
        }
        resultSet.close();
        return bl;
    }

    private String getUDTClassName(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        String string2 = null;
        try {
            if (string.charAt(0) != '\"') {
                return string;
            }
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string);
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            ResultSet resultSet = databaseMetaData.getUDTs(null, string3, string4, new int[]{2000});
            if (resultSet.next()) {
                string2 = resultSet.getString(4);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
        if (string2 == null) {
            string2 = "???";
        }
        return string2;
    }

    public static final boolean importExportSupportedType(int n) {
        return n != -7 && n != 1111 && n != 2009;
    }

    private String getTypeOption(String string, int n, int n2, int n3) {
        if ((string.equals("CHAR") || string.equals("BLOB") || string.equals("CLOB") || string.equals("VARCHAR")) && n != 0) {
            return "(" + n + ")";
        }
        if (string.equals("FLOAT") && n2 != 0) {
            return "(" + n2 + ")";
        }
        if (string.equals("DECIMAL") || string.equals("NUMERIC")) {
            if (n2 != 0 && n3 == 0) {
                return "(" + n2 + ")";
            }
            if (n2 != 0 && n3 != 0) {
                return "(" + n2 + "," + n3 + ")";
            }
            if (n2 == 0 && n3 != 0) {
                return "(" + n3 + ")";
            }
        }
        if ((string.equals("DECIMAL") || string.equals("NUMERIC")) && n3 != 0) {
            return "(" + n3 + ")";
        }
        return "";
    }

    public String getColumnTypeNames() throws Exception {
        return ExportAbstract.stringifyObject(this.columnTypes);
    }

    public String getUDTClassNames() throws Exception {
        return ExportAbstract.stringifyObject(this.udtClassNames);
    }

    public String getColumnNamesWithCasts() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = this.vtiColumnNames.size();
        for (int i = 0; i < this.noOfColumns && i < n; ++i) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            String string = this.columnTypes.get(i);
            String string2 = this.vtiColumnNames.get(i);
            if (string.startsWith("SMALLINT") || string.startsWith("INTEGER") || string.startsWith("DECIMAL") || string.startsWith("BIGINT") || string.startsWith("NUMERIC")) {
                stringBuffer.append(" cast(" + string2 + " AS " + string + ") ");
                continue;
            }
            if (string.startsWith("DOUBLE")) {
                stringBuffer.append(" DOUBLE(" + string2 + ") ");
                continue;
            }
            if (string.startsWith("REAL")) {
                stringBuffer.append("cast( DOUBLE(" + string2 + ")  AS REAL) ");
                continue;
            }
            stringBuffer.append(" " + string2 + " ");
        }
        if (bl) {
            return " * ";
        }
        return stringBuffer.toString();
    }

    public String getInsertColumnNames() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < this.noOfColumns; ++i) {
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            String string = this.insertColumnNames.get(i);
            stringBuffer.append(IdUtil.normalToDelimited(string));
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getExpectedNumberOfColumnsInFile() {
        return this.expectedNumberOfCols;
    }

    private boolean tableExists() throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, this.schemaName, this.tableName, null);
        boolean bl = false;
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        return bl;
    }

    public String getExpectedVtiColumnTypesAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < this.noOfColumns && i < this.vtiColumnNames.size(); ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.vtiColumnNames.get(i) + ":" + String.valueOf(this.jdbcColumnTypes.get(i)));
        }
        if (bl) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static int[] getExpectedVtiColumnTypes(String string, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 12;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(":");
            int n3 = Integer.parseInt(string2.substring(6, n2));
            int n4 = Integer.parseInt(string2.substring(n2 + 1));
            if (n3 > n) continue;
            nArray[n3 - 1] = n4;
        }
        return nArray;
    }

    public static String[] getExpectedColumnTypeNames(String string, int n) throws Exception {
        ArrayList arrayList = (ArrayList)ImportAbstract.destringifyObject(string);
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static HashMap getExpectedUDTClasses(String string) throws Exception {
        HashMap hashMap = ColumnInfo.deserializeHashMap(string);
        if (hashMap == null) {
            return null;
        }
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            Class<?> clazz = Class.forName(string3);
            hashMap2.put(string2, clazz);
        }
        return hashMap2;
    }

    public static HashMap deserializeHashMap(String string) throws Exception {
        if (string == null) {
            return null;
        }
        HashMap hashMap = (HashMap)ImportAbstract.destringifyObject(string);
        return hashMap;
    }
}

