/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import java.util.List;
import java.util.Objects;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.message.MailboxName;
import org.apache.james.mailbox.model.MailboxACL;

public final class ListRightsResponse
implements ImapResponseMessage {
    private final MailboxACL.EntryKey entryKey;
    private final MailboxName mailboxName;
    private final List<MailboxACL.Rfc4314Rights> rights;

    public ListRightsResponse(MailboxName mailboxName, MailboxACL.EntryKey entryKey, List<MailboxACL.Rfc4314Rights> rights) {
        this.mailboxName = mailboxName;
        this.entryKey = entryKey;
        this.rights = rights;
    }

    public MailboxACL.EntryKey getEntryKey() {
        return this.entryKey;
    }

    public MailboxName getMailboxName() {
        return this.mailboxName;
    }

    public List<MailboxACL.Rfc4314Rights> getRights() {
        return this.rights;
    }

    public final boolean equals(Object o) {
        if (o instanceof ListRightsResponse) {
            ListRightsResponse other = (ListRightsResponse)o;
            return Objects.equals(this.mailboxName, other.mailboxName) && Objects.equals(this.entryKey, other.entryKey) && Objects.equals(this.rights, other.rights);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mailboxName, this.entryKey, this.rights);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(ImapConstants.LISTRIGHTS_COMMAND.getName()).append(' ').append(this.mailboxName).append(' ').append(this.entryKey);
        for (MailboxACL.Rfc4314Rights optionalRightsGroup : this.rights) {
            result.append(' ').append(optionalRightsGroup.toString());
        }
        return result.toString();
    }
}

