/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.metrics.logger;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.james.metrics.api.Metric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetric
implements Metric {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMetric.class);
    private final AtomicInteger value;
    private final String metricName;

    public DefaultMetric(String metricName) {
        this.metricName = metricName;
        this.value = new AtomicInteger();
    }

    public void increment() {
        this.value.incrementAndGet();
    }

    public void decrement() {
        this.value.decrementAndGet();
    }

    public void add(int i) {
        this.value.addAndGet(i);
    }

    public void remove(int i) {
        this.value.addAndGet(-1 * i);
    }

    public long getCount() {
        long counter = this.value.longValue();
        if (counter < 0L) {
            LOGGER.error("counter value({}) of the metric '{}' should not be a negative number", (Object)this.value, (Object)this.metricName);
            return 0L;
        }
        return counter;
    }
}

