/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.cert;

import java.security.Principal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CertificateDN
implements Principal {
    private String commonName = null;
    private String country = null;
    private String domainComponent = null;
    private String email = null;
    private String locality = null;
    private String name;
    private String organization = null;
    private String organizationalUnit = null;
    private String state = null;

    public CertificateDN(Principal dn) {
        if (dn == null) {
            throw new IllegalArgumentException("Disinguished name cannot be null.");
        }
        this.name = dn.getName();
        Pattern p = Pattern.compile("(CN|E|OU|O|L|ST|C|DC)=(\"{0,1})(.+?)(\\2),");
        Matcher m = p.matcher(dn.getName() + ",");
        while (m.find()) {
            String key = m.group(1);
            String value = m.group(3);
            if ("CN".equals(key)) {
                this.commonName = value;
                continue;
            }
            if ("E".equals(key)) {
                this.email = value;
                continue;
            }
            if ("OU".equals(key)) {
                this.organizationalUnit = value;
                continue;
            }
            if ("O".equals(key)) {
                this.organization = value;
                continue;
            }
            if ("L".equals(key)) {
                this.locality = value;
                continue;
            }
            if ("ST".equals(key)) {
                this.state = value;
                continue;
            }
            if ("C".equals(key)) {
                this.country = value;
                continue;
            }
            if (!"DC".equals(key)) continue;
            this.domainComponent = value;
        }
    }

    public final String getCommonName() {
        return this.commonName;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getDomainComponent() {
        return this.domainComponent;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getLocality() {
        return this.locality;
    }

    public final String getName() {
        return this.name;
    }

    public final String getOrganization() {
        return this.organization;
    }

    public final String getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public final String getState() {
        return this.state;
    }
}

