/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.misc.BitFieldSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrackedOffset
implements Comparable<TrackedOffset> {
    private static final int F_AFTER_SPACE_EDIT = BitFieldSet.intMask((Enum)Flags.AFTER_SPACE_EDIT);
    private static final int F_AFTER_INSERT = BitFieldSet.intMask((Enum)Flags.AFTER_INSERT);
    private static final int F_AFTER_DELETE = BitFieldSet.intMask((Enum)Flags.AFTER_DELETE);
    @Nullable
    private final TrackedOffset original;
    private final int offset;
    private final int flags;
    private int spacesBefore;
    private int spacesAfter;
    private boolean isSpliced;
    private int index;

    private TrackedOffset(int offset, boolean afterSpaceEdit, boolean afterInsert, boolean afterDelete) {
        this.original = null;
        this.offset = offset;
        int flags = 0;
        if (afterSpaceEdit) {
            flags |= F_AFTER_SPACE_EDIT;
        }
        if (afterInsert) {
            flags |= F_AFTER_INSERT;
        }
        if (afterDelete) {
            flags |= F_AFTER_DELETE;
        }
        this.flags = flags;
        this.index = -1;
        this.spacesBefore = -1;
        this.spacesAfter = -1;
    }

    private TrackedOffset(@NotNull TrackedOffset other) {
        this.original = other.original;
        this.offset = other.offset;
        this.flags = other.flags;
        this.index = -1;
        this.spacesBefore = other.spacesBefore;
        this.spacesAfter = other.spacesAfter;
    }

    private TrackedOffset(@NotNull TrackedOffset other, int offset) {
        this.original = other;
        this.offset = offset;
        this.flags = other.flags;
        this.index = -1;
        this.spacesBefore = other.spacesBefore;
        this.spacesAfter = other.spacesAfter;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSpacesBefore() {
        return this.spacesBefore;
    }

    public void setSpacesBefore(int spacesBefore) {
        this.spacesBefore = spacesBefore;
    }

    public int getSpacesAfter() {
        return this.spacesAfter;
    }

    public void setSpacesAfter(int spacesAfter) {
        this.spacesAfter = spacesAfter;
    }

    public boolean isSpliced() {
        return this.isSpliced;
    }

    public void setSpliced(boolean spliced) {
        this.isSpliced = spliced;
    }

    public boolean isResolved() {
        return this.index != -1;
    }

    public int getIndex() {
        return this.index == -1 ? this.offset : this.index;
    }

    public void setIndex(int index) {
        if (this.original != null) {
            this.original.index = index;
        }
        this.index = index;
    }

    public boolean isAfterSpaceEdit() {
        return BitFieldSet.any((long)this.flags, (long)F_AFTER_SPACE_EDIT);
    }

    public boolean isAfterInsert() {
        return BitFieldSet.any((long)this.flags, (long)F_AFTER_INSERT);
    }

    public boolean isAfterDelete() {
        return BitFieldSet.any((long)this.flags, (long)F_AFTER_DELETE);
    }

    @NotNull
    public TrackedOffset plusOffsetDelta(int delta) {
        return new TrackedOffset(this, this.offset + delta);
    }

    @NotNull
    public TrackedOffset withOffset(int offset) {
        return new TrackedOffset(this, offset);
    }

    @Override
    public int compareTo(@NotNull TrackedOffset o) {
        return Integer.compare(this.offset, o.offset);
    }

    @Override
    public int compareTo(@NotNull Integer o) {
        return Integer.compare(this.offset, o);
    }

    @Override
    public int compareTo(int offset) {
        return Integer.compare(this.offset, offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() && !(o instanceof Integer)) {
            return false;
        }
        if (o instanceof Integer) {
            return (Integer)o == this.offset;
        }
        TrackedOffset offset = (TrackedOffset)o;
        return this.offset == offset.offset;
    }

    public int hashCode() {
        return this.offset;
    }

    public String toString() {
        return "{" + this.offset + (this.isSpliced() ? " ><" : "") + (String)(this.spacesBefore >= 0 || this.spacesAfter >= 0 ? " " + (this.spacesBefore >= 0 ? Integer.toString(this.spacesBefore) : "?") + "|" + (this.spacesAfter >= 0 ? Integer.toString(this.spacesAfter) : "?") : "") + (String)(BitFieldSet.any((long)this.flags, (long)(F_AFTER_SPACE_EDIT | F_AFTER_INSERT | F_AFTER_DELETE)) ? " " + (this.isAfterSpaceEdit() ? "s" : "") + (this.isAfterInsert() ? "i" : "") + (this.isAfterDelete() ? "d" : "") : "") + (String)(this.isResolved() ? " -> " + this.index : "") + "}";
    }

    public static TrackedOffset track(@NotNull TrackedOffset other) {
        return new TrackedOffset(other);
    }

    public static TrackedOffset track(int offset) {
        return TrackedOffset.track(offset, false, false, false);
    }

    public static TrackedOffset track(int offset, @Nullable Character c, boolean afterDelete) {
        return TrackedOffset.track(offset, c != null && c.charValue() == ' ', c != null && !afterDelete, afterDelete);
    }

    public static TrackedOffset track(int offset, boolean afterSpaceEdit, boolean afterInsert, boolean afterDelete) {
        assert (!afterInsert && !afterDelete || afterInsert != afterDelete) : "Cannot have both afterInsert and afterDelete true";
        return new TrackedOffset(offset, afterSpaceEdit, afterInsert, afterDelete);
    }

    private static enum Flags {
        AFTER_SPACE_EDIT,
        AFTER_INSERT,
        AFTER_DELETE;

    }
}

