/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.Plugin;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.url.URLConstructor;
import org.apache.wiki.util.comparators.PrincipalComparator;

public class Groups
implements Plugin {
    private static final Comparator<Principal> COMPARATOR = new PrincipalComparator();

    public String execute(Context context, Map<String, String> params) throws PluginException {
        Engine engine = context.getEngine();
        GroupManager groupMgr = (GroupManager)engine.getManager(GroupManager.class);
        Principal[] groups = groupMgr.getRoles();
        Arrays.sort(groups, COMPARATOR);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < groups.length; ++i) {
            String name = groups[i].getName();
            String url = ((URLConstructor)engine.getManager(URLConstructor.class)).makeURL(ContextEnum.GROUP_VIEW.getRequestContext(), name, null);
            s.append("<a href=\"");
            s.append(url);
            s.append("\">");
            s.append(name);
            s.append("</a>");
            if (i >= groups.length - 1) continue;
            s.append(',');
            s.append(' ');
        }
        return s.toString();
    }
}

