/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.progress;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.ajax.WikiAjaxDispatcherServlet;
import org.apache.wiki.ajax.WikiAjaxServlet;
import org.apache.wiki.ui.progress.ProgressItem;
import org.apache.wiki.ui.progress.ProgressManager;

public class DefaultProgressManager
implements ProgressManager {
    private final Map<String, ProgressItem> m_progressingTasks = new ConcurrentHashMap<String, ProgressItem>();
    private static final Logger LOG = LogManager.getLogger(DefaultProgressManager.class);

    public DefaultProgressManager() {
        WikiAjaxDispatcherServlet.registerServlet("progressTracker", new JSONTracker());
    }

    @Override
    public String getNewProgressIdentifier() {
        return UUID.randomUUID().toString();
    }

    @Override
    public void startProgress(ProgressItem pi, String id) {
        LOG.debug("Adding " + id + " to progress queue");
        this.m_progressingTasks.put(id, pi);
        pi.setState(1);
    }

    @Override
    public void stopProgress(String id) {
        LOG.debug("Removed " + id + " from progress queue");
        ProgressItem pi = this.m_progressingTasks.remove(id);
        if (pi != null) {
            pi.setState(2);
        }
    }

    @Override
    public int getProgress(String id) throws IllegalArgumentException {
        ProgressItem pi = this.m_progressingTasks.get(id);
        if (pi != null) {
            return pi.getProgress();
        }
        throw new IllegalArgumentException("No such id was found");
    }

    public class JSONTracker
    implements WikiAjaxServlet {
        public int getProgress(String progressId) {
            return DefaultProgressManager.this.getProgress(progressId);
        }

        @Override
        public String getServletMapping() {
            return "progressTracker";
        }

        @Override
        public void service(HttpServletRequest req, HttpServletResponse resp, String actionName, List<String> params) throws IOException {
            LOG.debug("ProgressManager.doGet() START");
            if (params.isEmpty()) {
                return;
            }
            String progressId = params.get(0);
            LOG.debug("progressId=" + progressId);
            String progressString = "";
            try {
                progressString = Integer.toString(this.getProgress(progressId));
            }
            catch (IllegalArgumentException e) {
                LOG.debug("progressId " + progressId + " is no longer valid");
            }
            LOG.debug("progressString=" + progressString);
            resp.getWriter().write(progressString);
            LOG.debug("ProgressManager.doGet() DONE");
        }
    }
}

