/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client2;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.ParseException;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Visibility;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.header.BasicCsvArrayHeader;
import org.apache.juneau.http.header.BasicDateHeader;
import org.apache.juneau.http.header.BasicEntityTagArrayHeader;
import org.apache.juneau.http.header.BasicEntityTagHeader;
import org.apache.juneau.http.header.BasicIntegerHeader;
import org.apache.juneau.http.header.BasicLongHeader;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.http.header.BasicStringRangeArrayHeader;
import org.apache.juneau.http.header.BasicUriHeader;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SimplePartParser;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.rest.client2.RestCallException;
import org.apache.juneau.rest.client2.RestRequest;
import org.apache.juneau.rest.client2.RestResponse;
import org.apache.juneau.utils.Mutable;

public class RestResponseHeader
implements Header {
    static final Header NULL_HEADER = new Header(){

        public String getName() {
            return null;
        }

        public String getValue() {
            return null;
        }

        public HeaderElement[] getElements() throws ParseException {
            return new HeaderElement[0];
        }
    };
    private final Header header;
    private final RestRequest request;
    private final RestResponse response;
    private HttpPartParserSession parser;
    private HttpPartSchema schema;

    public RestResponseHeader(RestRequest request, RestResponse response, Header header) {
        this.request = request;
        this.response = response;
        this.header = header == null ? NULL_HEADER : header;
        this.parser(null);
    }

    public RestResponseHeader schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public RestResponseHeader parser(HttpPartParserSession value) {
        this.parser = value == null ? SimplePartParser.DEFAULT_SESSION : value;
        return this;
    }

    public boolean exists() {
        return this.header != NULL_HEADER;
    }

    public String asString() {
        return this.getValue();
    }

    public <T extends BasicHeader> T asHeader(Class<T> c) {
        try {
            ClassInfo ci = ClassInfo.of(c);
            ConstructorInfo cc = ci.getConstructor(Visibility.PUBLIC, new Class[]{String.class});
            if (cc != null) {
                return (T)((BasicHeader)cc.invoke(new Object[]{this.asString()}));
            }
            cc = ci.getConstructor(Visibility.PUBLIC, new Class[]{String.class, String.class});
            if (cc != null) {
                return (T)((BasicHeader)cc.invoke(new Object[]{this.getName(), this.asString()}));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new BasicRuntimeException("Could not determine a method to construct type {0}", new Object[]{c.getClass().getName()});
    }

    public BasicCsvArrayHeader asCsvArrayHeader() {
        return new BasicCsvArrayHeader(this.getName(), (Object)this.getValue());
    }

    public BasicDateHeader asDateHeader() {
        return new BasicDateHeader(this.getName(), (Object)this.getValue());
    }

    public BasicEntityTagArrayHeader asEntityTagArrayHeader() {
        return new BasicEntityTagArrayHeader(this.getName(), (Object)this.getValue());
    }

    public BasicEntityTagHeader asEntityTagHeader() {
        return new BasicEntityTagHeader(this.getName(), (Object)this.getValue());
    }

    public BasicIntegerHeader asIntegerHeader() {
        return new BasicIntegerHeader(this.getName(), (Object)this.getValue());
    }

    public BasicLongHeader asLongHeader() {
        return new BasicLongHeader(this.getName(), (Object)this.getValue());
    }

    public BasicStringRangeArrayHeader asStringRangeArrayHeader() {
        return new BasicStringRangeArrayHeader(this.getName(), (Object)this.getValue());
    }

    public BasicStringHeader asStringHeader() {
        return new BasicStringHeader(this.getName(), (Object)this.getValue());
    }

    public BasicUriHeader asUriHeader() {
        return new BasicUriHeader(this.getName(), (Object)this.getValue());
    }

    public RestResponse asString(Mutable<String> m) {
        m.set((Object)this.asString());
        return this.response;
    }

    public Optional<String> asOptionalString() {
        return Optional.ofNullable(this.getValue());
    }

    public String asStringOrElse(String def) {
        return this.getValue() == null ? def : this.getValue();
    }

    public RestResponse asStringOrElse(Mutable<String> m, String def) {
        m.set((Object)this.asStringOrElse(def));
        return this.response;
    }

    public <T> T as(Type type, Type ... args) throws RestCallException {
        return this.as(this.request.getClassMeta(type, args));
    }

    public <T> RestResponse as(Mutable<T> m, Type type, Type ... args) throws RestCallException {
        m.set(this.as(type, args));
        return this.response;
    }

    public <T> T as(Class<T> type) throws RestCallException {
        return this.as(this.request.getClassMeta(type));
    }

    public <T> RestResponse as(Mutable<T> m, Class<T> type) throws RestCallException {
        m.set(this.as(type));
        return this.response;
    }

    public <T> T as(ClassMeta<T> type) throws RestCallException {
        try {
            return (T)this.parser.parse(HttpPartType.HEADER, this.schema, this.asString(), type);
        }
        catch (org.apache.juneau.parser.ParseException e) {
            throw new RestCallException(this.response, e, "Could not parse response header {0}.", this.getName());
        }
    }

    public <T> RestResponse as(Mutable<T> m, ClassMeta<T> type) throws RestCallException {
        m.set(this.as(type));
        return this.response;
    }

    public <T> Optional<T> asOptional(Type type, Type ... args) throws RestCallException {
        return Optional.ofNullable(this.as(type, args));
    }

    public <T> RestResponse asOptional(Mutable<Optional<T>> m, Type type, Type ... args) throws RestCallException {
        m.set(this.asOptional(type, args));
        return this.response;
    }

    public <T> Optional<T> asOptional(Class<T> type) throws RestCallException {
        return Optional.ofNullable(this.as(type));
    }

    public <T> RestResponse asOptional(Mutable<Optional<T>> m, Class<T> type) throws RestCallException {
        m.set(this.asOptional(type));
        return this.response;
    }

    public <T> Optional<T> asOptional(ClassMeta<T> type) throws RestCallException {
        return Optional.ofNullable(this.as(type));
    }

    public <T> RestResponse asOptional(Mutable<Optional<T>> m, ClassMeta<T> type) throws RestCallException {
        m.set(this.asOptional(type));
        return this.response;
    }

    public Matcher asMatcher(Pattern pattern) throws RestCallException {
        return pattern.matcher(this.asStringOrElse(""));
    }

    public RestResponse asMatcher(Mutable<Matcher> m, Pattern pattern) throws RestCallException {
        m.set((Object)pattern.matcher(this.asStringOrElse("")));
        return this.response;
    }

    public Matcher asMatcher(String regex) throws RestCallException {
        return this.asMatcher(regex, 0);
    }

    public RestResponse asMatcher(Mutable<Matcher> m, String regex) throws RestCallException {
        m.set((Object)this.asMatcher(regex, 0));
        return this.response;
    }

    public Matcher asMatcher(String regex, int flags) throws RestCallException {
        return this.asMatcher(Pattern.compile(regex, flags));
    }

    public RestResponse asMatcher(Mutable<Matcher> m, String regex, int flags) throws RestCallException {
        m.set((Object)this.asMatcher(Pattern.compile(regex, flags)));
        return this.response;
    }

    public RestResponse toResponse() {
        return this.response;
    }

    public FluentStringAssertion<RestResponse> assertString() {
        return new FluentStringAssertion(this.asString(), (Object)this.response);
    }

    public FluentIntegerAssertion<RestResponse> assertInteger() {
        return new FluentIntegerAssertion(this.asIntegerHeader().asInt(), (Object)this.response);
    }

    public FluentLongAssertion<RestResponse> assertLong() {
        return new FluentLongAssertion(this.asLongHeader().asLong(), (Object)this.response);
    }

    public FluentZonedDateTimeAssertion<RestResponse> assertDate() {
        return new FluentZonedDateTimeAssertion(this.asDateHeader().asZonedDateTime(), (Object)this.response);
    }

    public FluentListAssertion<RestResponse> assertCsvArray() {
        return new FluentListAssertion(this.asCsvArrayHeader().asList(), (Object)this.response);
    }

    public String getName() {
        return this.header.getName();
    }

    public String getValue() {
        return this.header.getValue();
    }

    public HeaderElement[] getElements() throws ParseException {
        return this.header.getElements();
    }

    public String toString() {
        return this.getName() + ": " + this.getValue();
    }
}

