/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.encoders.IdentityEncoder;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.exception.BadRequest;
import org.apache.juneau.http.exception.InternalServerError;
import org.apache.juneau.http.exception.NotFound;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.HttpUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.ClientVersionMatcher;
import org.apache.juneau.rest.Enablement;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RequestPath;
import org.apache.juneau.rest.RequestProperties;
import org.apache.juneau.rest.ResponsePartMeta;
import org.apache.juneau.rest.RestCall;
import org.apache.juneau.rest.RestCallLoggerConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestMatcher;
import org.apache.juneau.rest.RestMethodContextBuilder;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestMethodProperties;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.guards.RoleBasedRestGuard;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathInfo;
import org.apache.juneau.rest.util.UrlPathPattern;
import org.apache.juneau.rest.util.UrlPathPatternMatch;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.utils.MethodInvoker;

@ConfigurableContext(nocache=true)
public class RestMethodContext
extends BeanContext
implements Comparable<RestMethodContext> {
    static final String PREFIX = "RestMethodContext";
    @Deprecated
    public static final String RESTMETHOD_attrs = "RestMethodContext.reqAttrs.smo";
    public static final String RESTMETHOD_clientVersion = "RestMethodContext.clientVersion.s";
    public static final String RESTMETHOD_debug = "RestMethodContext.debug.s";
    public static final String RESTMETHOD_defaultFormData = "RestMethodContext.defaultFormData.omo";
    public static final String RESTMETHOD_defaultQuery = "RestMethodContext.defaultQuery.omo";
    @Deprecated
    public static final String RESTMETHOD_defaultRequestHeaders = "RestMethodContext.reqHeaders.smo";
    public static final String RESTMETHOD_httpMethod = "RestMethodContext.httpMethod.s";
    public static final String RESTMETHOD_callLoggerConfig = "RestMethodContext.callLoggerConfig.o";
    public static final String RESTMETHOD_matchers = "RestMethodContext.matchers.lo";
    @Deprecated
    public static final String RESTMETHOD_path = "RestMethodContext.path.s";
    public static final String RESTMETHOD_paths = "RestMethodContext.paths.ls";
    public static final String RESTMETHOD_priority = "RestMethodContext.priority.i";
    public static final String RESTMETHOD_reqAttrs = "RestMethodContext.reqAttrs.smo";
    public static final String RESTMETHOD_reqHeaders = "RestMethodContext.reqHeaders.smo";
    private final String httpMethod;
    private final UrlPathPattern[] pathPatterns;
    final RestMethodParam[] methodParams;
    private final RestGuard[] guards;
    private final RestMatcher[] optionalMatchers;
    private final RestMatcher[] requiredMatchers;
    private final RestConverter[] converters;
    private final RestMethodProperties properties;
    private final Integer priority;
    private final RestContext context;
    final Method method;
    final MethodInvoker methodInvoker;
    final MethodInfo mi;
    final SerializerGroup serializers;
    final ParserGroup parsers;
    final EncoderGroup encoders;
    final HttpPartSerializer partSerializer;
    final HttpPartParser partParser;
    final JsonSchemaGenerator jsonSchemaGenerator;
    final Map<String, Object> reqHeaders;
    final Map<String, Object> defaultQuery;
    final Map<String, Object> defaultFormData;
    final OMap reqAttrs;
    final String defaultCharset;
    final long maxInput;
    final Map<String, Widget> widgets;
    final List<MediaType> supportedAcceptTypes;
    final List<MediaType> supportedContentTypes;
    final RestCallLoggerConfig callLoggerConfig;
    final Map<Class<?>, ResponseBeanMeta> responseBeanMetas = new ConcurrentHashMap();
    final Map<Class<?>, ResponsePartMeta> headerPartMetas = new ConcurrentHashMap();
    final Map<Class<?>, ResponsePartMeta> bodyPartMetas = new ConcurrentHashMap();
    final ResponseBeanMeta responseMeta;
    final Map<Integer, AtomicInteger> statusCodes = new ConcurrentHashMap<Integer, AtomicInteger>();
    final Enablement debug;
    final int hierarchyDepth;

    /*
     * WARNING - void declaration
     */
    RestMethodContext(RestMethodContextBuilder b) throws ServletException {
        super(b.getPropertyStore());
        this.context = b.context;
        this.method = b.method;
        this.methodInvoker = new MethodInvoker(this.method, this.context.getMethodExecStats(this.method));
        this.mi = MethodInfo.of((Method)this.method);
        this.mi.setAccessible();
        int hd = 0;
        for (Class<?> sc = b.method.getDeclaringClass().getSuperclass(); sc != null; sc = sc.getSuperclass()) {
            ++hd;
        }
        this.hierarchyDepth = hd;
        PropertyStore ps = this.getPropertyStore();
        RestResourceResolver rr = this.context.getResourceResolver();
        Object r = this.context.getResource();
        String _httpMethod = (String)this.getProperty(RESTMETHOD_httpMethod, String.class, null);
        if (_httpMethod == null) {
            _httpMethod = HttpUtils.detectHttpMethod((Method)this.method, (boolean)true, (String)"GET");
        }
        if ("METHOD".equals(_httpMethod)) {
            _httpMethod = "*";
        }
        this.httpMethod = _httpMethod.toUpperCase(Locale.ENGLISH);
        this.defaultCharset = (String)this.getProperty("RestContext.defaultCharset.s", String.class, "utf-8");
        this.maxInput = StringUtils.parseLongWithSuffix((String)((String)this.getProperty("RestContext.maxInput.s", String.class, "100M")));
        this.serializers = SerializerGroup.create().append(this.getArrayProperty("RestContext.serializers.lo", Object.class)).apply(ps).build();
        this.parsers = ParserGroup.create().append(this.getArrayProperty("RestContext.parsers.lo", Object.class)).apply(ps).build();
        HttpPartParser hpp = this.context.getPartParser();
        if (hpp instanceof Parser) {
            Parser pp = (Parser)hpp;
            hpp = (HttpPartParser)pp.builder().apply(ps).build();
        }
        this.partParser = hpp;
        this.partSerializer = this.context.getPartSerializer();
        this.responseMeta = ResponseBeanMeta.create((MethodInfo)this.mi, (PropertyStore)ps);
        boolean dotAll = b.dotAll;
        ArrayList<UrlPathPattern> pathPatterns = new ArrayList<UrlPathPattern>();
        for (String string : (String[])this.getArrayProperty(RESTMETHOD_paths, String.class)) {
            void var14_17;
            if (dotAll && !string.endsWith("/*")) {
                String string2 = string + "/*";
            }
            pathPatterns.add(new UrlPathPattern((String)var14_17));
        }
        if (pathPatterns.isEmpty()) {
            String p = HttpUtils.detectHttpPath((Method)this.method, (boolean)true);
            if (dotAll && !p.endsWith("/*")) {
                p = p + "/*";
            }
            pathPatterns.add(new UrlPathPattern(p));
        }
        this.pathPatterns = pathPatterns.toArray(new UrlPathPattern[pathPatterns.size()]);
        this.methodParams = this.context.findParams(this.mi, false, this.pathPatterns[this.pathPatterns.length - 1]);
        this.converters = (RestConverter[])this.getInstanceArrayProperty("RestContext.converters.lo", RestConverter.class, new RestConverter[0], rr, new Object[]{r, this});
        AList _guards = AList.of();
        _guards.a(this.getInstanceArrayProperty("RestContext.guards.lo", RestGuard.class, new RestGuard[0], rr, new Object[]{r, this}));
        Set rolesDeclared = this.getSetProperty("RestContext.rolesDeclared.ss", String.class, null);
        Set roleGuard = this.getSetProperty("RestContext.roleGuard.ss", String.class, Collections.emptySet());
        for (String rg : roleGuard) {
            try {
                _guards.add((Object)new RoleBasedRestGuard(rolesDeclared, rg));
            }
            catch (java.text.ParseException e1) {
                throw new ServletException((Throwable)e1);
            }
        }
        this.guards = (RestGuard[])_guards.toArray((Object[])new RestGuard[_guards.size()]);
        LinkedList<RestMatcher> linkedList = new LinkedList<RestMatcher>();
        LinkedList<RestMatcher> requiredMatchers = new LinkedList<RestMatcher>();
        for (RestMatcher matcher : (RestMatcher[])this.getInstanceArrayProperty(RESTMETHOD_matchers, RestMatcher.class, new RestMatcher[0], rr, new Object[]{r, this})) {
            if (matcher.mustMatch()) {
                requiredMatchers.add(matcher);
                continue;
            }
            linkedList.add(matcher);
        }
        String clientVersion = (String)this.getProperty(RESTMETHOD_clientVersion, String.class, null);
        if (clientVersion != null) {
            requiredMatchers.add(new ClientVersionMatcher(this.context.getClientVersionHeader(), this.mi));
        }
        this.requiredMatchers = requiredMatchers.toArray(new RestMatcher[requiredMatchers.size()]);
        this.optionalMatchers = linkedList.toArray(new RestMatcher[linkedList.size()]);
        this.encoders = EncoderGroup.create().append(new Encoder[]{IdentityEncoder.INSTANCE}).append((Encoder[])this.getInstanceArrayProperty("RestContext.encoders.lo", Encoder.class, new Encoder[0], rr, new Object[]{r, this})).build();
        this.jsonSchemaGenerator = JsonSchemaGenerator.create().apply(ps).build();
        TreeMap<String, Object> _reqHeaders = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        _reqHeaders.putAll(this.getMapProperty("RestMethodContext.reqHeaders.smo", Object.class));
        OMap _reqAttrs = new OMap((Map)this.context.getReqAttrs()).appendAll(this.getMapProperty("RestMethodContext.reqAttrs.smo", Object.class));
        LinkedHashMap<String, Object> _defaultQuery = new LinkedHashMap<String, Object>(this.getMapProperty(RESTMETHOD_defaultQuery, Object.class));
        LinkedHashMap<String, Object> _defaultFormData = new LinkedHashMap<String, Object>(this.getMapProperty(RESTMETHOD_defaultFormData, Object.class));
        Type[] pt = this.method.getGenericParameterTypes();
        Annotation[][] pa = this.method.getParameterAnnotations();
        for (int i = 0; i < pt.length; ++i) {
            for (Annotation a : pa[i]) {
                FormData f;
                String def;
                if (a instanceof Header) {
                    Header h = (Header)a;
                    def = this.joinnlFirstNonEmptyArray(h._default(), h.df());
                    if (def == null) continue;
                    try {
                        _reqHeaders.put(StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.n(), h.value()}), RestUtils.parseAnything(def));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ConfigException((Throwable)e, "Malformed @Header annotation", new Object[0]);
                    }
                }
                if (a instanceof Query) {
                    Query q = (Query)a;
                    def = this.joinnlFirstNonEmptyArray(q._default(), q.df());
                    if (def == null) continue;
                    try {
                        _defaultQuery.put(StringUtils.firstNonEmpty((String[])new String[]{q.name(), q.n(), q.value()}), RestUtils.parseAnything(def));
                        continue;
                    }
                    catch (ParseException e) {
                        throw new ConfigException((Throwable)e, "Malformed @Query annotation", new Object[0]);
                    }
                }
                if (!(a instanceof FormData) || (def = this.joinnlFirstNonEmptyArray((f = (FormData)a)._default(), f.df())) == null) continue;
                try {
                    _defaultFormData.put(StringUtils.firstNonEmpty((String[])new String[]{f.name(), f.value(), f.n()}), RestUtils.parseAnything(def));
                }
                catch (ParseException e) {
                    throw new ConfigException((Throwable)e, "Malformed @FormData annotation", new Object[0]);
                }
            }
        }
        this.reqHeaders = Collections.unmodifiableMap(_reqHeaders);
        this.reqAttrs = _reqAttrs.unmodifiable();
        this.defaultQuery = Collections.unmodifiableMap(_defaultQuery);
        this.defaultFormData = Collections.unmodifiableMap(_defaultFormData);
        this.priority = this.getIntegerProperty(RESTMETHOD_priority, 0);
        AMap _widgets = AMap.of();
        for (Widget w : (Widget[])this.getInstanceArrayProperty("RestContext.widgets.lo", Widget.class, new Widget[0])) {
            _widgets.put((Object)w.getName(), (Object)w);
        }
        this.widgets = _widgets.unmodifiable();
        this.properties = b.properties;
        this.supportedAcceptTypes = this.getListProperty("RestContext.produces.ls", MediaType.class, this.serializers.getSupportedMediaTypes());
        this.supportedContentTypes = this.getListProperty("RestContext.consumes.ls", MediaType.class, this.parsers.getSupportedMediaTypes());
        this.debug = this.context.getDebug(this.method);
        Object clc = this.getProperty(RESTMETHOD_callLoggerConfig);
        this.callLoggerConfig = clc instanceof RestCallLoggerConfig ? (RestCallLoggerConfig)clc : (clc instanceof OMap ? RestCallLoggerConfig.create().parent(this.context.getCallLoggerConfig()).apply((OMap)clc).build() : this.context.getCallLoggerConfig());
    }

    private String joinnlFirstNonEmptyArray(String[] ... s) {
        for (Object[] objectArray : s) {
            if (objectArray.length <= 0) continue;
            return StringUtils.joinnl((Object[])objectArray);
        }
        return null;
    }

    ResponseBeanMeta getResponseBeanMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponseBeanMeta rbm = this.responseBeanMetas.get(c);
        if (rbm == null) {
            rbm = ResponseBeanMeta.create(c, (PropertyStore)this.serializers.getPropertyStore());
            if (rbm == null) {
                rbm = ResponseBeanMeta.NULL;
            }
            this.responseBeanMetas.put(c, rbm);
        }
        if (rbm == ResponseBeanMeta.NULL) {
            return null;
        }
        return rbm;
    }

    ResponsePartMeta getResponseHeaderMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponsePartMeta pm = this.headerPartMetas.get(c);
        if (pm == null) {
            ResponseHeader a = c.getAnnotation(ResponseHeader.class);
            if (a != null) {
                HttpPartSchema schema = HttpPartSchema.create((Annotation)a);
                HttpPartSerializer serializer = RestMethodContext.createPartSerializer(schema.getSerializer(), this.serializers.getPropertyStore(), this.partSerializer);
                pm = new ResponsePartMeta(HttpPartType.HEADER, schema, serializer);
            }
            if (pm == null) {
                pm = ResponsePartMeta.NULL;
            }
            this.headerPartMetas.put(c, pm);
        }
        if (pm == ResponsePartMeta.NULL) {
            return null;
        }
        return pm;
    }

    ResponsePartMeta getResponseBodyMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponsePartMeta pm = this.bodyPartMetas.get(c);
        if (pm == null) {
            ResponseBody a = c.getAnnotation(ResponseBody.class);
            if (a != null) {
                HttpPartSchema schema = HttpPartSchema.create((Annotation)a);
                HttpPartSerializer serializer = RestMethodContext.createPartSerializer(schema.getSerializer(), this.serializers.getPropertyStore(), this.partSerializer);
                pm = new ResponsePartMeta(HttpPartType.BODY, schema, serializer);
            }
            if (pm == null) {
                pm = ResponsePartMeta.NULL;
            }
            this.bodyPartMetas.put(c, pm);
        }
        if (pm == ResponsePartMeta.NULL) {
            return null;
        }
        return pm;
    }

    boolean hasGuardsOrMatchers() {
        return this.guards.length != 0 || this.requiredMatchers.length != 0 || this.optionalMatchers.length != 0;
    }

    String getHttpMethod() {
        return this.httpMethod;
    }

    String getPathPattern() {
        return this.pathPatterns[0].toString();
    }

    boolean isRequestAllowed(RestRequest req) {
        for (RestGuard guard : this.guards) {
            req.setJavaMethod(this.method);
            if (guard.isRequestAllowed(req)) continue;
            return false;
        }
        return true;
    }

    boolean matches(UrlPathInfo pathInfo) {
        for (UrlPathPattern p : this.pathPatterns) {
            if (p.match(pathInfo) == null) continue;
            return true;
        }
        return false;
    }

    protected int match(RestCall call) {
        UrlPathPatternMatch pm = this.matchPattern(call);
        if (pm == null) {
            return 0;
        }
        if (this.requiredMatchers.length == 0 && this.optionalMatchers.length == 0) {
            call.urlPathPatternMatch(pm);
            return 2;
        }
        try {
            RestRequest req = call.getRestRequest();
            RestResponse res = call.getRestResponse();
            RequestProperties requestProperties = new RequestProperties(req.getVarResolverSession(), this.properties);
            req.init(this, requestProperties);
            res.init(this, requestProperties);
            for (RestMatcher m : this.requiredMatchers) {
                if (m.matches(req)) continue;
                return 1;
            }
            if (this.optionalMatchers.length > 0) {
                boolean matches = false;
                for (RestMatcher m : this.optionalMatchers) {
                    matches |= m.matches(req);
                }
                if (!matches) {
                    return 1;
                }
            }
            call.urlPathPatternMatch(pm);
            return 2;
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e);
        }
    }

    private UrlPathPatternMatch matchPattern(RestCall call) {
        UrlPathPatternMatch pm = null;
        for (UrlPathPattern pp : this.pathPatterns) {
            if (pm != null) continue;
            pm = pp.match(call.getUrlPathInfo());
        }
        return pm;
    }

    void invoke(RestCall call) throws Throwable {
        UrlPathPatternMatch pm = call.getUrlPathPatternMatch();
        if (pm == null) {
            pm = this.matchPattern(call);
        }
        if (pm == null) {
            throw new NotFound();
        }
        RestRequest req = call.getRestRequest();
        RestResponse res = call.getRestResponse();
        RequestPath rp = req.getPathMatch();
        for (Map.Entry<String, String> e : pm.getVars().entrySet()) {
            rp.put(e.getKey(), e.getValue());
        }
        if (pm.getRemainder() != null) {
            rp.remainder(pm.getRemainder());
        }
        RequestProperties requestProperties = new RequestProperties(req.getVarResolverSession(), this.properties);
        req.init(this, requestProperties);
        res.init(this, requestProperties);
        this.context.preCall(call);
        call.loggerConfig(this.callLoggerConfig);
        if (this.debug == Enablement.TRUE) {
            call.debug(true);
            call.loggerConfig(RestCallLoggerConfig.DEFAULT_DEBUG);
        } else if (this.debug == Enablement.FALSE) {
            call.debug(false);
            call.loggerConfig(RestCallLoggerConfig.DEFAULT_NOOP);
        } else if (this.debug == Enablement.PER_REQUEST) {
            boolean b = "true".equalsIgnoreCase(req.getHeader("X-Debug"));
            if (b) {
                call.debug(true);
                call.loggerConfig(RestCallLoggerConfig.DEFAULT_DEBUG);
            } else {
                call.debug(false);
                call.loggerConfig(RestCallLoggerConfig.DEFAULT_NOOP);
            }
        }
        Object[] args = new Object[this.methodParams.length];
        for (int i = 0; i < this.methodParams.length; ++i) {
            try {
                args[i] = this.methodParams[i].resolve(req, res);
                continue;
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, BadRequest.class, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", this.methodParams[i].getParamType().name(), this.methodParams[i].getName(), this.methodParams[i].getType(), this.mi.getDeclaringClass().getFullName(), this.mi.getSimpleName());
            }
        }
        try {
            for (RestGuard guard : this.guards) {
                if (guard.guard(req, res)) continue;
                return;
            }
            try {
                Object output = this.methodInvoker.invoke(this.context.getResource(), args);
                Boolean debug = (Boolean)ObjectUtils.castOrNull((Object)req.getAttribute("Debug"), Boolean.class);
                if (debug == Boolean.TRUE) {
                    call.debug(true);
                    call.loggerConfig(RestCallLoggerConfig.DEFAULT_DEBUG);
                } else if (debug == Boolean.FALSE) {
                    call.debug(false);
                    call.loggerConfig(RestCallLoggerConfig.DEFAULT_NOOP);
                }
                if (res.getStatus() == 0) {
                    res.setStatus(200);
                }
                if (!(this.method.getReturnType().equals(Void.TYPE) || output == null && res.getOutputStreamCalled())) {
                    res.setOutput(output);
                }
            }
            catch (InvocationTargetException e) {
                Throwable e2 = e.getTargetException();
                res.setStatus(500);
                ResponsePartMeta rpm = this.getResponseBodyMeta(e2);
                ResponseBeanMeta rbm = this.getResponseBeanMeta(e2);
                if (rpm != null || rbm != null) {
                    res.setOutput(e2);
                    res.setResponseMeta(rbm);
                }
                throw e;
            }
            this.context.postCall(call);
            if (res.hasOutput()) {
                for (RestConverter converter : this.converters) {
                    res.setOutput(converter.convert(req, res.getOutput()));
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadRequest((Throwable)e, "Invalid argument type passed to the following method: ''{0}''.\n\tArgument types: {1}", new Object[]{this.mi.toString(), this.mi.getFullName()});
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    @Override
    public int compareTo(RestMethodContext o) {
        int i;
        int c = this.priority.compareTo(o.priority);
        if (c != 0) {
            return c;
        }
        for (i = 0; i < Math.min(this.pathPatterns.length, o.pathPatterns.length); ++i) {
            c = this.pathPatterns[i].compareTo(o.pathPatterns[i]);
            if (c == 0) continue;
            return c;
        }
        c = ObjectUtils.compare((int)o.hierarchyDepth, (int)this.hierarchyDepth);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)o.requiredMatchers.length, (int)this.requiredMatchers.length);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)o.optionalMatchers.length, (int)this.optionalMatchers.length);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)o.guards.length, (int)this.guards.length);
        if (c != 0) {
            return c;
        }
        c = StringUtils.compare((String)this.method.getName(), (String)o.method.getName());
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)this.method.getParameterCount(), (int)o.method.getParameterCount());
        if (c != 0) {
            return c;
        }
        for (i = 0; i < this.method.getParameterCount(); ++i) {
            c = StringUtils.compare((String)this.method.getParameterTypes()[i].getName(), (String)o.method.getParameterTypes()[i].getName());
            if (c == 0) continue;
            return c;
        }
        c = StringUtils.compare((String)this.method.getReturnType().getName(), (String)o.method.getReturnType().getName());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public SerializerGroup getSerializers() {
        return this.serializers;
    }

    public ParserGroup getParsers() {
        return this.parsers;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    protected RestCallLoggerConfig getCallLoggerConfig() {
        return this.callLoggerConfig;
    }

    Enablement getDebug() {
        return this.debug;
    }

    public boolean equals(Object o) {
        return o instanceof RestMethodContext && ObjectUtils.eq((Object)this, (Object)((RestMethodContext)o), (x, y) -> x.method.equals(y.method));
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    static String[] resolveVars(VarResolver vr, String[] in) {
        String[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = vr.resolve(in[i]);
        }
        return out;
    }

    static HttpPartSerializer createPartSerializer(Class<? extends HttpPartSerializer> c, PropertyStore ps, HttpPartSerializer _default) {
        HttpPartSerializer hps = (HttpPartSerializer)ClassUtils.castOrCreate(HttpPartSerializer.class, c, (boolean)true, (Object[])new Object[]{ps});
        return hps == null ? _default : hps;
    }

    public OMap toMap() {
        return super.toMap().a(PREFIX, (Object)new DefaultFilteringOMap().a("defaultFormData", this.defaultFormData).a("defaultQuery", this.defaultQuery).a("reqHeaders", this.reqHeaders).a("httpMethod", (Object)this.httpMethod).a("priority", (Object)this.priority));
    }
}

