/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.juneau.AddFlag;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.ContextCache;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.ResourceResolver;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.BasicNameValuePair;
import org.apache.juneau.http.HeaderSupplier;
import org.apache.juneau.http.HttpMethod;
import org.apache.juneau.http.HttpResource;
import org.apache.juneau.http.NameValuePairSupplier;
import org.apache.juneau.http.SerializedHeader;
import org.apache.juneau.http.SerializedHttpEntity;
import org.apache.juneau.http.SerializedNameValuePair;
import org.apache.juneau.http.remote.RemoteReturn;
import org.apache.juneau.http.remote.RrpcInterfaceMeta;
import org.apache.juneau.http.remote.RrpcInterfaceMethodMeta;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.httppart.bean.RequestBeanPropertyMeta;
import org.apache.juneau.internal.StateMachineState;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.parser.ParserGroupBuilder;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.client.remote.RemoteMeta;
import org.apache.juneau.rest.client.remote.RemoteMetadataException;
import org.apache.juneau.rest.client.remote.RemoteMethodArg;
import org.apache.juneau.rest.client.remote.RemoteMethodBeanArg;
import org.apache.juneau.rest.client.remote.RemoteMethodMeta;
import org.apache.juneau.rest.client.remote.RemoteMethodReturn;
import org.apache.juneau.rest.client2.BasicRestCallHandler;
import org.apache.juneau.rest.client2.RestCallException;
import org.apache.juneau.rest.client2.RestCallHandler;
import org.apache.juneau.rest.client2.RestCallInterceptor;
import org.apache.juneau.rest.client2.RestClientBuilder;
import org.apache.juneau.rest.client2.RestRequest;
import org.apache.juneau.rest.client2.RestResponse;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerGroupBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

@ConfigurableContext(nocache=true)
public class RestClient
extends BeanContext
implements HttpClient,
Closeable,
RestCallHandler,
RestCallInterceptor {
    private static final String PREFIX = "RestClient.";
    public static final String RESTCLIENT_callHandler = "RestClient.callHandler.o";
    public static final String RESTCLIENT_console = "RestClient.console.o";
    public static final String RESTCLIENT_errorCodes = "RestClient.errorCodes.o";
    public static final String RESTCLIENT_executorService = "RestClient.executorService.o";
    public static final String RESTCLIENT_executorServiceShutdownOnClose = "RestClient.executorServiceShutdownOnClose.b";
    public static final String RESTCLIENT_formData = "RestClient.formData.lo";
    public static final String RESTCLIENT_headers = "RestClient.headers.lo";
    public static final String RESTCLIENT_ignoreErrors = "RestClient.ignoreErrors.b";
    public static final String RESTCLIENT_interceptors = "RestClient.interceptors.lo";
    public static final String RESTCLIENT_interceptors_add = "RestClient.interceptors.so/add";
    public static final String RESTCLIENT_keepHttpClientOpen = "RestClient.keepHttpClientOpen.b";
    public static final String RESTCLIENT_leakDetection = "RestClient.leakDetection.b";
    public static final String RESTCLIENT_logger = "RestClient.logger.o";
    public static final String RESTCLIENT_logToConsole = "RestClient.logToConsole.b";
    public static final String RESTCLIENT_logRequests = "RestClient.logRequests.s";
    public static final String RESTCLIENT_logRequestsLevel = "RestClient.logRequestsLevel.s";
    public static final String RESTCLIENT_logRequestsPredicate = "RestClient.logRequestsPredicate.o";
    public static final String RESTCLIENT_parsers = "RestClient.parsers.lo";
    public static final String RESTCLIENT_partParser = "RestClient.partParser.o";
    public static final String RESTCLIENT_partSerializer = "RestClient.partSerializer.o";
    public static final String RESTCLIENT_query = "RestClient.query.lo";
    public static final String RESTCLIENT_rootUri = "RestClient.rootUri.s";
    public static final String RESTCLIENT_serializers = "RestClient.serializers.lo";
    static final String RESTCLIENT_httpClient = "RestClient.httpClient.o";
    static final String RESTCLIENT_httpClientBuilder = "RestClient.httpClientBuilder.o";
    private final HeaderSupplier headers;
    private final NameValuePairSupplier query;
    private final NameValuePairSupplier formData;
    final CloseableHttpClient httpClient;
    private final boolean keepHttpClientOpen;
    private final boolean leakDetection;
    private final UrlEncodingSerializer urlEncodingSerializer;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final RestCallHandler callHandler;
    private final String rootUri;
    private volatile boolean isClosed = false;
    private final StackTraceElement[] creationStack;
    private final Logger logger;
    final DetailLevel logRequests;
    final BiPredicate<RestRequest, RestResponse> logRequestsPredicate;
    final Level logRequestsLevel;
    final boolean ignoreErrors;
    private final boolean logToConsole;
    private final PrintStream console;
    private StackTraceElement[] closedStack;
    private static final ConcurrentHashMap<Class<?>, Context> requestContexts = new ConcurrentHashMap();
    final SerializerGroup serializers;
    final ParserGroup parsers;
    Predicate<Integer> errorCodes;
    final RestCallInterceptor[] interceptors;
    private volatile ExecutorService executorService;
    private final boolean executorServiceShutdownOnClose;
    private static final Predicate<Integer> ERROR_CODES_DEFAULT = x -> x <= 0 || x >= 400;
    private static final BiPredicate<RestRequest, RestResponse> LOG_REQUESTS_PREDICATE_DEFAULT = (req, res) -> true;
    private Pattern absUrlPattern = Pattern.compile("^\\w+\\:\\/\\/.*");

    public static RestClientBuilder create() {
        return new RestClientBuilder(PropertyStore.DEFAULT);
    }

    @Override
    public RestClientBuilder builder() {
        return new RestClientBuilder(this.getPropertyStore());
    }

    protected RestClient(PropertyStore ps) {
        super(ps);
        this.httpClient = this.getInstanceProperty(RESTCLIENT_httpClient, CloseableHttpClient.class, null);
        this.keepHttpClientOpen = this.getBooleanProperty(RESTCLIENT_keepHttpClientOpen, false);
        this.errorCodes = this.getInstanceProperty(RESTCLIENT_errorCodes, Predicate.class, ERROR_CODES_DEFAULT);
        this.executorServiceShutdownOnClose = this.getBooleanProperty(RESTCLIENT_executorServiceShutdownOnClose, false);
        this.rootUri = StringUtils.nullIfEmpty(this.getStringProperty(RESTCLIENT_rootUri, "").replaceAll("\\/$", ""));
        this.leakDetection = this.getBooleanProperty(RESTCLIENT_leakDetection, this.isDebug());
        this.ignoreErrors = this.getBooleanProperty(RESTCLIENT_ignoreErrors, false);
        this.logger = this.getInstanceProperty(RESTCLIENT_logger, Logger.class, Logger.getLogger(RestClient.class.getName()));
        this.logRequests = this.getInstanceProperty(RESTCLIENT_logRequests, DetailLevel.class, (Object)(this.isDebug() ? DetailLevel.FULL : DetailLevel.NONE));
        this.logRequestsLevel = this.getInstanceProperty(RESTCLIENT_logRequestsLevel, Level.class, this.isDebug() ? Level.WARNING : Level.OFF);
        this.logToConsole = this.getBooleanProperty(RESTCLIENT_logToConsole, this.isDebug());
        this.console = this.getInstanceProperty(RESTCLIENT_console, PrintStream.class, System.err);
        this.logRequestsPredicate = this.getInstanceProperty(RESTCLIENT_logRequestsPredicate, BiPredicate.class, LOG_REQUESTS_PREDICATE_DEFAULT);
        SerializerGroupBuilder sgb = SerializerGroup.create();
        for (Object o : this.getArrayProperty(RESTCLIENT_serializers, Object.class)) {
            if (o instanceof Serializer) {
                sgb.append((Serializer)o);
                continue;
            }
            if (o instanceof Class) {
                Class c = (Class)o;
                if (!Serializer.class.isAssignableFrom(c)) {
                    throw new ConfigException("RESTCLIENT_serializers property had invalid class of type ''{0}''", c.getName());
                }
                sgb.append((Serializer)ContextCache.INSTANCE.create((Class)o, ps));
                continue;
            }
            throw new ConfigException("RESTCLIENT_serializers property had invalid object of type ''{0}''", o.getClass().getName());
        }
        this.serializers = sgb.build();
        ParserGroupBuilder pgb = ParserGroup.create();
        for (Object o : this.getArrayProperty(RESTCLIENT_parsers, Object.class)) {
            if (o instanceof Parser) {
                pgb.append((Parser)o);
                continue;
            }
            if (o instanceof Class) {
                Class c = (Class)o;
                if (!Parser.class.isAssignableFrom(c)) {
                    throw new ConfigException("RESTCLIENT_parsers property had invalid class of type ''{0}''", c.getName());
                }
                pgb.append((Parser)ContextCache.INSTANCE.create((Class)o, ps));
                continue;
            }
            throw new ConfigException("RESTCLIENT_parsers property had invalid object of type ''{0}''", o.getClass().getName());
        }
        this.parsers = pgb.build();
        this.urlEncodingSerializer = new SerializerBuilder(ps).build(UrlEncodingSerializer.class);
        this.partSerializer = this.getInstanceProperty(RESTCLIENT_partSerializer, HttpPartSerializer.class, OpenApiSerializer.class, ResourceResolver.FUZZY, ps);
        this.partParser = this.getInstanceProperty(RESTCLIENT_partParser, HttpPartParser.class, OpenApiParser.class, ResourceResolver.FUZZY, ps);
        this.executorService = this.getInstanceProperty(RESTCLIENT_executorService, ExecutorService.class, null);
        HttpPartSerializerSession partSerializerSession = this.partSerializer.createPartSession(null);
        this.headers = HeaderSupplier.create();
        for (Object o : this.getListProperty(RESTCLIENT_headers, Object.class)) {
            if ((o = RestClient.buildBuilders(o, partSerializerSession)) instanceof HeaderSupplier) {
                this.headers.add((HeaderSupplier)o);
                continue;
            }
            this.headers.add(BasicHeader.cast(o));
        }
        this.query = NameValuePairSupplier.create();
        for (Object o : this.getListProperty(RESTCLIENT_query, Object.class)) {
            if ((o = RestClient.buildBuilders(o, partSerializerSession)) instanceof NameValuePairSupplier) {
                this.query.add((NameValuePairSupplier)o);
                continue;
            }
            this.query.add(BasicNameValuePair.cast(o));
        }
        this.formData = NameValuePairSupplier.create();
        for (Object o : this.getListProperty(RESTCLIENT_formData, Object.class)) {
            if ((o = RestClient.buildBuilders(o, partSerializerSession)) instanceof NameValuePairSupplier) {
                this.formData.add((NameValuePairSupplier)o);
                continue;
            }
            this.formData.add(BasicNameValuePair.cast(o));
        }
        this.callHandler = this.getInstanceProperty(RESTCLIENT_callHandler, RestCallHandler.class, BasicRestCallHandler.class, ResourceResolver.FUZZY, ps, this);
        this.interceptors = this.getInstanceArrayProperty(RESTCLIENT_interceptors, RestCallInterceptor.class, new RestCallInterceptor[0]);
        this.creationStack = this.isDebug() ? Thread.currentThread().getStackTrace() : null;
    }

    private static Object buildBuilders(Object o, HttpPartSerializerSession ss) {
        if (o instanceof SerializedHeader) {
            return ((SerializedHeader)o).serializer(ss, false);
        }
        if (o instanceof SerializedNameValuePair) {
            return ((SerializedNameValuePair)o).serializer(ss, false);
        }
        return o;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (!this.keepHttpClientOpen) {
            this.httpClient.close();
        }
        if (this.executorService != null && this.executorServiceShutdownOnClose) {
            this.executorService.shutdown();
        }
        if (this.creationStack != null) {
            this.closedStack = Thread.currentThread().getStackTrace();
        }
    }

    public void closeQuietly() {
        this.isClosed = true;
        try {
            if (!this.keepHttpClientOpen) {
                this.httpClient.close();
            }
            if (this.executorService != null && this.executorServiceShutdownOnClose) {
                this.executorService.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.creationStack != null) {
            this.closedStack = Thread.currentThread().getStackTrace();
        }
    }

    @Override
    public HttpResponse run(HttpHost target, HttpRequest request, HttpContext context) throws ClientProtocolException, IOException {
        return this.callHandler.run(target, request, context);
    }

    public RestRequest get(Object uri) throws RestCallException {
        return this.request("GET", uri, false);
    }

    public RestRequest get() throws RestCallException {
        return this.request("GET", (Object)null, false);
    }

    public RestRequest put(Object uri, Object body) throws RestCallException {
        return this.request("PUT", uri, true).body(body);
    }

    public RestRequest put(Object uri, String body, String contentType) throws RestCallException {
        return this.request("PUT", uri, true).bodyString(body).contentType(contentType);
    }

    public RestRequest put(Object uri) throws RestCallException {
        return this.request("PUT", uri, true);
    }

    public RestRequest post(Object uri, Object body) throws RestCallException {
        return this.request("POST", uri, true).body(body);
    }

    public RestRequest post(Object uri, String body, String contentType) throws RestCallException {
        return this.request("POST", uri, true).bodyString(body).contentType(contentType);
    }

    public RestRequest post(Object uri) throws RestCallException {
        return this.request("POST", uri, true);
    }

    public RestRequest delete(Object uri) throws RestCallException {
        return this.request("DELETE", uri, false);
    }

    public RestRequest options(Object uri) throws RestCallException {
        return this.request("OPTIONS", uri, true);
    }

    public RestRequest head(Object uri) throws RestCallException {
        return this.request("HEAD", uri, false);
    }

    public RestRequest formPost(Object uri, Object body) throws RestCallException {
        RestRequest req = this.request("POST", uri, true);
        try {
            if (body instanceof Supplier) {
                body = ((Supplier)body).get();
            }
            if (body instanceof NameValuePair) {
                return req.body(new UrlEncodedFormEntity(AList.of(new NameValuePair[]{(NameValuePair)body})));
            }
            if (body instanceof NameValuePair[]) {
                return req.body(new UrlEncodedFormEntity(Arrays.asList((NameValuePair[])body)));
            }
            if (body instanceof NameValuePairSupplier) {
                return req.body(new UrlEncodedFormEntity((Iterable)((NameValuePairSupplier)body)));
            }
            if (body instanceof HttpResource) {
                for (Header h : ((HttpResource)body).getHeaders()) {
                    req.header(h);
                }
            }
            if (body instanceof HttpEntity) {
                HttpEntity e = (HttpEntity)body;
                if (e.getContentType() == null) {
                    req.contentType("application/x-www-form-urlencoded");
                }
                return req.body(e);
            }
            if (body instanceof Reader || body instanceof InputStream) {
                return req.contentType("application/x-www-form-urlencoded").body(body);
            }
            return req.body((Object)SerializedHttpEntity.of(body, (Serializer)this.urlEncodingSerializer));
        }
        catch (IOException e) {
            throw new RestCallException(null, e, "Could not read form post body.", new Object[0]);
        }
    }

    public RestRequest formPost(Object uri) throws RestCallException {
        return this.request("POST", uri, true);
    }

    public RestRequest formPostPairs(Object uri, Object ... parameters) throws RestCallException {
        return this.formPost(uri, NameValuePairSupplier.ofPairs(parameters));
    }

    public RestRequest patch(Object uri, Object body) throws RestCallException {
        return this.request("PATCH", uri, true).body(body);
    }

    public RestRequest patch(Object uri, String body, String contentType) throws RestCallException {
        return this.request("PATCH", uri, true).bodyString(body).contentType(contentType);
    }

    public RestRequest patch(Object uri) throws RestCallException {
        return this.request("PATCH", uri, true);
    }

    public RestRequest callback(String callString) throws RestCallException {
        callString = StringUtils.emptyIfNull(callString);
        StateMachineState state = StateMachineState.S01;
        int mark = 0;
        String method = null;
        String headers = null;
        String uri = null;
        String content = null;
        for (int i = 0; i < callString.length(); ++i) {
            char c = callString.charAt(i);
            if (state == StateMachineState.S01) {
                if (!Character.isWhitespace(c)) continue;
                method = callString.substring(mark, i);
                state = StateMachineState.S02;
                continue;
            }
            if (state == StateMachineState.S02) {
                if (Character.isWhitespace(c)) continue;
                mark = i;
                if (c == '{') {
                    state = StateMachineState.S03;
                    continue;
                }
                state = StateMachineState.S05;
                continue;
            }
            if (state == StateMachineState.S03) {
                if (c != '}') continue;
                headers = callString.substring(mark, i + 1);
                state = StateMachineState.S04;
                continue;
            }
            if (state == StateMachineState.S04) {
                if (Character.isWhitespace(c)) continue;
                mark = i;
                state = StateMachineState.S05;
                continue;
            }
            if (!Character.isWhitespace(c)) continue;
            uri = callString.substring(mark, i);
            content = callString.substring(i).trim();
            break;
        }
        if (state != StateMachineState.S05) {
            throw new RestCallException(null, null, "Invalid format for call string.  State={0}", new Object[]{state});
        }
        try {
            RestRequest req = this.request(method, (Object)uri, StringUtils.isNotEmpty(content));
            if (headers != null) {
                for (Map.Entry<String, Object> e : OMap.ofJson(headers).entrySet()) {
                    req.header(BasicHeader.of(e.getKey(), e.getValue()));
                }
            }
            if (StringUtils.isNotEmpty(content)) {
                req.bodyString(content);
            }
            return req;
        }
        catch (ParseException e) {
            throw new RestCallException(null, e, "Invalid format for call string.", new Object[0]);
        }
    }

    public RestRequest request(String method, Object uri, Object body) throws RestCallException {
        boolean b = HttpMethod.hasContent(method);
        RestRequest rc = this.request(method, uri, b);
        if (b) {
            rc.body(body);
        }
        return rc;
    }

    public RestRequest request(String method, Object uri) throws RestCallException {
        RestRequest rc = this.request(method, uri, HttpMethod.hasContent(method));
        return rc;
    }

    public RestRequest request(String method, Object uri, boolean hasBody) throws RestCallException {
        if (method == null) {
            method = "GET";
        }
        if (this.isClosed) {
            Exception e2 = null;
            if (this.closedStack != null) {
                e2 = new Exception("Creation stack:");
                e2.setStackTrace(this.closedStack);
                throw new RestCallException(null, e2, "RestClient.close() has already been called.  This client cannot be reused.", new Object[0]);
            }
            throw new RestCallException(null, null, "RestClient.close() has already been called.  This client cannot be reused.  Closed location stack trace can be displayed by setting the system property 'org.apache.juneau.rest.client2.RestClient.trackCreation' to true.", new Object[0]);
        }
        RestRequest req = this.createRequest(this.toURI(uri, this.rootUri), method.toUpperCase(Locale.ENGLISH), hasBody);
        for (Header o : this.headers) {
            req.header(BasicHeader.cast(o));
        }
        for (Header o : this.query) {
            req.query(BasicNameValuePair.cast(o));
        }
        for (Header o : this.formData) {
            req.formData(BasicNameValuePair.cast(o));
        }
        this.onInit(req);
        return req;
    }

    protected RestRequest createRequest(URI uri, String method, boolean hasBody) throws RestCallException {
        return new RestRequest(this, uri, method, hasBody);
    }

    protected RestResponse createResponse(RestRequest request, HttpResponse httpResponse, Parser parser) throws RestCallException {
        return new RestResponse(this, request, httpResponse, parser);
    }

    public <T> T getRemote(Class<T> interfaceClass) {
        return this.getRemote(interfaceClass, null);
    }

    public <T> T getRemote(Class<T> interfaceClass, Object rootUri) {
        return this.getRemote(interfaceClass, rootUri, null, null);
    }

    public <T> T getRemote(final Class<T> interfaceClass, Object rootUri, final Serializer serializer, final Parser parser) {
        if (rootUri == null) {
            rootUri = this.rootUri;
        }
        final String restUrl2 = StringUtils.trimSlashes(StringUtils.emptyIfNull(rootUri));
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){
            final RemoteMeta rm;
            {
                this.rm = new RemoteMeta(interfaceClass);
            }

            @Override
            public Object invoke(Object proxy, final Method method, Object[] args) throws Throwable {
                RemoteMethodReturn rmr;
                final RemoteMethodMeta rmm = this.rm.getMethodMeta(method);
                String uri = rmm.getFullPath();
                if (uri.indexOf("://") == -1) {
                    uri = restUrl2 + '/' + uri;
                }
                if (uri.indexOf("://") == -1) {
                    throw new RemoteMetadataException(interfaceClass, "Root URI has not been specified.  Cannot construct absolute path to remote resource.", new Object[0]);
                }
                String httpMethod = rmm.getHttpMethod();
                HttpPartSerializerSession s = RestClient.this.getPartSerializerSession();
                final RestRequest rc = RestClient.this.request(httpMethod, (Object)uri, HttpMethod.hasContent(httpMethod));
                rc.serializer(serializer);
                rc.parser(parser);
                for (Header h : this.rm.getHeaders()) {
                    rc.header(h);
                }
                for (RemoteMethodArg a : rmm.getPathArgs()) {
                    rc.pathArg(a.getName(), args[a.getIndex()], a.getSchema(), a.getSerializer(s));
                }
                for (RemoteMethodArg a : rmm.getQueryArgs()) {
                    rc.queryArg(a.isSkipIfEmpty() ? AddFlag.SKIP_IF_EMPTY_FLAGS : AddFlag.DEFAULT_FLAGS, a.getName(), args[a.getIndex()], a.getSchema(), a.getSerializer(s));
                }
                for (RemoteMethodArg a : rmm.getFormDataArgs()) {
                    rc.formDataArg(a.isSkipIfEmpty() ? AddFlag.SKIP_IF_EMPTY_FLAGS : AddFlag.DEFAULT_FLAGS, a.getName(), args[a.getIndex()], a.getSchema(), a.getSerializer(s));
                }
                for (RemoteMethodArg a : rmm.getHeaderArgs()) {
                    rc.headerArg(a.isSkipIfEmpty() ? AddFlag.SKIP_IF_EMPTY_FLAGS : AddFlag.DEFAULT_FLAGS, a.getName(), args[a.getIndex()], a.getSchema(), a.getSerializer(s));
                }
                RemoteMethodArg ba = rmm.getBodyArg();
                if (ba != null) {
                    rc.body(args[ba.getIndex()], ba.getSchema());
                }
                if (rmm.getRequestArgs().length > 0) {
                    for (RemoteMethodBeanArg rmba : rmm.getRequestArgs()) {
                        RequestBeanMeta rbm = rmba.getMeta();
                        Object bean = args[rmba.getIndex()];
                        if (bean == null) continue;
                        for (RequestBeanPropertyMeta p : rbm.getProperties()) {
                            EnumSet<AddFlag> flags;
                            Object val = p.getGetter().invoke(bean, new Object[0]);
                            HttpPartType pt = p.getPartType();
                            HttpPartSerializerSession ps = p.getSerializer(s);
                            String pn = p.getPartName();
                            HttpPartSchema schema = p.getSchema();
                            EnumSet<AddFlag> enumSet = flags = schema.isSkipIfEmpty() ? AddFlag.SKIP_IF_EMPTY_FLAGS : AddFlag.DEFAULT_FLAGS;
                            if (pt == HttpPartType.PATH) {
                                rc.pathArg(pn, val, schema, p.getSerializer(s));
                                continue;
                            }
                            if (val == null) continue;
                            if (pt == HttpPartType.QUERY) {
                                rc.queryArg(flags, pn, val, schema, ps);
                                continue;
                            }
                            if (pt == HttpPartType.FORMDATA) {
                                rc.formDataArg(flags, pn, val, schema, ps);
                                continue;
                            }
                            if (pt == HttpPartType.HEADER) {
                                rc.headerArg(flags, pn, val, schema, ps);
                                continue;
                            }
                            rc.body(val, schema);
                        }
                    }
                }
                if ((rmr = rmm.getReturns()).isFuture()) {
                    return RestClient.this.getExecutorService().submit(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            try {
                                return RestClient.this.executeRemote(interfaceClass, rc, method, rmm);
                            }
                            catch (Exception e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                if (rmr.isCompletableFuture()) {
                    final CompletableFuture cf = new CompletableFuture();
                    RestClient.this.getExecutorService().submit(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            try {
                                cf.complete(RestClient.this.executeRemote(interfaceClass, rc, method, rmm));
                            }
                            catch (Throwable e) {
                                cf.completeExceptionally(e);
                            }
                            return null;
                        }
                    });
                    return cf;
                }
                return RestClient.this.executeRemote(interfaceClass, rc, method, rmm);
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object executeRemote(Class<?> interfaceClass, RestRequest rc, Method method, RemoteMethodMeta rmm) throws Throwable {
        RemoteMethodReturn rmr = rmm.getReturns();
        try {
            Constable ret = null;
            RestResponse res = null;
            if (rmr.getReturnValue() == RemoteReturn.NONE) {
                res = rc.complete();
            } else if (rmr.getReturnValue() == RemoteReturn.STATUS) {
                res = rc.complete();
                int returnCode = res.getStatusCode();
                Class<?> clazz = method.getReturnType();
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    ret = returnCode;
                } else {
                    if (clazz != Boolean.class && clazz != Boolean.TYPE) throw new RestCallException(res, null, "Invalid return type on method annotated with @RemoteMethod(returns=RemoteReturn.STATUS).  Only integer and booleans types are valid.", new Object[0]);
                    ret = Boolean.valueOf(returnCode < 400);
                }
            } else if (rmr.getReturnValue() == RemoteReturn.BEAN) {
                rc.ignoreErrors();
                res = rc.run();
                ret = res.as(rmr.getResponseBeanMeta());
            } else {
                void var9_14;
                Object t;
                Class<?> rt = method.getReturnType();
                if (Throwable.class.isAssignableFrom(rt)) {
                    rc.ignoreErrors();
                }
                if ((t = (res = rc.run()).getBody().as(rmr.getReturnType(), new Type[0])) == null && rt.isPrimitive()) {
                    Object object = ClassInfo.of(rt).getPrimitiveDefault();
                }
                if (rt.getName().equals(res.getStringHeader("Exception-Name"))) {
                    res.removeHeaders("Exception-Name");
                }
                ret = var9_14;
            }
            ThrowableUtils.throwException(res.getStringHeader("Exception-Name"), res.getStringHeader("Exception-Message"), rmm.getExceptions());
            return ret;
        }
        catch (RestCallException e) {
            ThrowableUtils.throwException(e.getServerExceptionName(), e.getServerExceptionMessage(), rmm.getExceptions());
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public <T> T getRrpcInterface(Class<T> interfaceClass) {
        return this.getRrpcInterface(interfaceClass, null);
    }

    public <T> T getRrpcInterface(Class<T> interfaceClass, Object uri) {
        return this.getRrpcInterface(interfaceClass, uri, null, null);
    }

    public <T> T getRrpcInterface(final Class<T> interfaceClass, Object uri, final Serializer serializer, Parser parser) {
        if (uri == null) {
            RrpcInterfaceMeta rm = new RrpcInterfaceMeta(interfaceClass, "");
            String path = rm.getPath();
            if (path.indexOf("://") == -1) {
                if (StringUtils.isEmpty(this.rootUri)) {
                    throw new RemoteMetadataException(interfaceClass, "Root URI has not been specified.  Cannot construct absolute path to remote interface.", new Object[0]);
                }
                path = StringUtils.trimSlashes(this.rootUri) + '/' + path;
            }
            uri = path;
        }
        final String restUrl2 = StringUtils.stringify(uri);
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){
            final RrpcInterfaceMeta rm;
            {
                this.rm = new RrpcInterfaceMeta(interfaceClass, restUrl2);
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RrpcInterfaceMethodMeta rim = this.rm.getMethodMeta(method);
                String uri = rim.getUri();
                try {
                    RestRequest rc = RestClient.this.request("POST", (Object)uri, true).serializer(serializer).body(args);
                    Object v = rc.run().getBody().as(method.getGenericReturnType(), new Type[0]);
                    if (v == null && method.getReturnType().isPrimitive()) {
                        v = ClassInfo.of(method.getReturnType()).getPrimitiveDefault();
                    }
                    return v;
                }
                catch (RestCallException e) {
                    ThrowableUtils.throwException(e.getServerExceptionName(), e.getServerExceptionMessage(), method.getExceptionTypes());
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        if (this.leakDetection && !this.isClosed && !this.keepHttpClientOpen) {
            StringBuilder sb = new StringBuilder("WARNING:  RestClient garbage collected before it was finalized.");
            if (this.creationStack != null) {
                sb.append("\nCreation Stack:");
                for (StackTraceElement e : this.creationStack) {
                    sb.append("\n\t" + e);
                }
            }
            this.log(Level.WARNING, sb.toString(), new Object[0]);
        }
    }

    protected void log(Level level, Throwable t, String msg, Object ... args) {
        this.logger.log(level, t, this.msg(msg, args));
        if (this.logToConsole) {
            this.console.println(this.msg(msg, args).get());
            if (t != null) {
                t.printStackTrace(this.console);
            }
        }
    }

    protected void log(Level level, String msg, Object ... args) {
        this.logger.log(level, this.msg(msg, args));
        if (this.logToConsole) {
            this.console.println(this.msg(msg, args).get());
        }
    }

    private Supplier<String> msg(String msg, Object ... args) {
        return () -> args.length == 0 ? msg : MessageFormat.format(msg, args);
    }

    @Override
    public void onInit(RestRequest req) throws RestCallException {
        try {
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onInit(req);
            }
        }
        catch (RuntimeException | RestCallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestCallException(null, e, "Interceptor threw an exception on init.", new Object[0]);
        }
    }

    @Override
    public void onConnect(RestRequest req, RestResponse res) throws RestCallException {
        try {
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onConnect(req, res);
            }
        }
        catch (RuntimeException | RestCallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestCallException(res, e, "Interceptor threw an exception on connect.", new Object[0]);
        }
    }

    @Override
    public void onClose(RestRequest req, RestResponse res) throws RestCallException {
        try {
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onClose(req, res);
            }
        }
        catch (RuntimeException | RestCallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestCallException(res, e, "Interceptor threw an exception on close.", new Object[0]);
        }
    }

    @Deprecated
    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.httpClient.execute(request);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.httpClient.execute(request, context);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.httpClient.execute(target, request);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        return this.httpClient.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.httpClient.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.httpClient.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.httpClient.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        return (T)this.httpClient.execute(target, request, responseHandler, context);
    }

    HttpPartSerializerSession getPartSerializerSession() {
        return this.partSerializer.createPartSession(null);
    }

    HttpPartParserSession getPartParserSession() {
        return this.partParser.createPartSession(null);
    }

    URI toURI(Object x, String rootUri) throws RestCallException {
        try {
            String s;
            if (x instanceof URI) {
                return (URI)x;
            }
            if (x instanceof URL) {
                ((URL)x).toURI();
            }
            if (x instanceof URIBuilder) {
                return ((URIBuilder)x).build();
            }
            String string = s = x == null ? "" : x.toString();
            if (rootUri != null && !this.absUrlPattern.matcher(s).matches()) {
                if (s.isEmpty()) {
                    s = rootUri;
                } else {
                    StringBuilder sb = new StringBuilder(rootUri);
                    if (!s.startsWith("/")) {
                        sb.append('/');
                    }
                    sb.append(s);
                    s = sb.toString();
                }
            }
            s = StringUtils.fixUrl(s);
            return new URI(s);
        }
        catch (URISyntaxException e) {
            throw new RestCallException(null, e, "Invalid URI encountered:  {0}", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getExecutorService() {
        if (this.executorService != null) {
            return this.executorService;
        }
        RestClient restClient = this;
        synchronized (restClient) {
            this.executorService = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
            return this.executorService;
        }
    }

    Serializer getMatchingSerializer(String mediaType) {
        Serializer s;
        if (this.serializers.isEmpty()) {
            return null;
        }
        if (mediaType != null && (s = this.serializers.getSerializer(mediaType)) != null) {
            return s;
        }
        List<Serializer> l = this.serializers.getSerializers();
        return l.size() == 1 ? l.get(0) : null;
    }

    Parser getMatchingParser(String mediaType) {
        Parser p;
        if (this.parsers.isEmpty()) {
            return null;
        }
        if (mediaType != null && (p = this.parsers.getParser(mediaType)) != null) {
            return p;
        }
        List<Parser> l = this.parsers.getParsers();
        return l.size() == 1 ? l.get(0) : null;
    }

    <T extends Context> T getInstance(Class<T> c) {
        Context o = requestContexts.get(c);
        if (o == null) {
            o = ContextCache.INSTANCE.create(c, this.getPropertyStore());
            requestContexts.put(c, o);
        }
        return (T)o;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a("RestClient", new DefaultFilteringOMap().a("errorCodes", this.errorCodes).a("executorService", this.executorService).a("executorServiceShutdownOnClose", this.executorServiceShutdownOnClose).a("headers", this.headers).a("interceptors", this.interceptors).a("keepHttpClientOpen", this.keepHttpClientOpen).a("partParser", this.partParser).a("partSerializer", this.partSerializer).a("query", this.query).a("rootUri", this.rootUri));
    }
}

