/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.lang.reflect.Array;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.marshall.SimpleJson;

@FluentSetters(returns="FluentArrayAssertion<R>")
public class FluentArrayAssertion<R>
extends FluentObjectAssertion<R> {
    private Object value;

    public FluentArrayAssertion(Object contents, R returns) {
        this(null, contents, returns);
    }

    public FluentArrayAssertion(Assertion creator, Object contents, R returns) {
        super(creator, contents, returns);
        this.value = contents;
    }

    public R isEmpty() throws AssertionError {
        this.exists();
        if (Array.getLength(this.value) != 0) {
            throw this.error("Array was not empty.", new Object[0]);
        }
        return this.returns();
    }

    public R isNotEmpty() throws AssertionError {
        this.exists();
        if (Array.getLength(this.value) == 0) {
            throw this.error("Array was empty.", new Object[0]);
        }
        return this.returns();
    }

    public R isSize(int size) throws AssertionError {
        this.exists();
        if (Array.getLength(this.value) != size) {
            throw this.error("Array did not have the expected size.  Expected={0}, Actual={1}.", size, Array.getLength(this.value));
        }
        return this.returns();
    }

    public R contains(Object value) throws AssertionError {
        this.exists();
        for (int i = 0; i < Array.getLength(this.value); ++i) {
            if (!ObjectUtils.eq(Array.get(this.value, i), value)) continue;
            return this.returns();
        }
        throw this.error("Array did not contain expected value.\nContents: {0}\nExpected:{1}", SimpleJson.DEFAULT.toString(this.value), value);
    }

    public R doesNotContain(Object value) throws AssertionError {
        this.exists();
        for (int i = 0; i < Array.getLength(this.value); ++i) {
            if (!ObjectUtils.eq(Array.get(this.value, i), value)) continue;
            throw this.error("Array contain unexpected value.\nContents: {0}\nUnexpected:{1}", SimpleJson.DEFAULT.toString(this.value), value);
        }
        return this.returns();
    }

    public FluentObjectAssertion<R> item(int index) {
        return new FluentObjectAssertion(this, this.getItem(index), this.returns());
    }

    private Object getItem(int index) {
        if (this.value != null && Array.getLength(this.value) > index) {
            return Array.get(this.value, index);
        }
        return null;
    }

    @Override
    public FluentArrayAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentArrayAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentArrayAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

