/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.http.EntityTag;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicDateHeader;

@Header(value="If-Range")
public class IfRange
extends BasicDateHeader {
    private static final long serialVersionUID = 1L;
    private final Object value;

    public static IfRange of(Object value) {
        if (value == null) {
            return null;
        }
        return new IfRange(value);
    }

    public static IfRange of(Supplier<?> value) {
        if (value == null) {
            return null;
        }
        return new IfRange(value);
    }

    public IfRange(Object value) {
        super("If-Range", IfRange.dateValue(value));
        this.value = IfRange.etagValue(value);
    }

    public IfRange(String value) {
        this((Object)value);
    }

    private static Object dateValue(Object o) {
        Object o2 = IfRange.unwrap(o);
        if (o2 == null || IfRange.isEtag(o2)) {
            return null;
        }
        return o;
    }

    private static Object etagValue(Object o) {
        Object o2 = IfRange.unwrap(o);
        if (o2 == null || IfRange.isEtag(o2)) {
            return o;
        }
        return null;
    }

    private static boolean isEtag(Object o) {
        String s = o.toString();
        return s.startsWith("\"") || s.startsWith("W/");
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return super.getValue();
        }
        Object o = IfRange.unwrap(this.value);
        return o == null ? null : o.toString();
    }

    public EntityTag asEntityTag() {
        return this.value == null ? null : EntityTag.of(this.value);
    }
}

