/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.jsonschema.BasicBeanDefMapper;
import org.apache.juneau.jsonschema.BeanDefMapper;
import org.apache.juneau.jsonschema.JsonSchemaBeanPropertyMeta;
import org.apache.juneau.jsonschema.JsonSchemaClassMeta;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorBuilder;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.JsonSchemaMetaProvider;
import org.apache.juneau.jsonschema.TypeCategory;

@ConfigurableContext
public class JsonSchemaGenerator
extends BeanTraverseContext
implements JsonSchemaMetaProvider {
    static final String PREFIX = "JsonSchemaGenerator";
    public static final String JSONSCHEMA_addDescriptionsTo = "JsonSchemaGenerator.addDescriptionsTo.s";
    public static final String JSONSCHEMA_addExamplesTo = "JsonSchemaGenerator.addExamplesTo.s";
    public static final String JSONSCHEMA_allowNestedDescriptions = "JsonSchemaGenerator.allowNestedDescriptions.b";
    public static final String JSONSCHEMA_allowNestedExamples = "JsonSchemaGenerator.allowNestedExamples.b";
    public static final String JSONSCHEMA_beanDefMapper = "JsonSchemaGenerator.beanDefMapper.o";
    public static final String JSONSCHEMA_defaultSchemas = "JsonSchemaGenerator.defaultSchemas.smo";
    public static final String JSONSCHEMA_ignoreTypes = "JsonSchemaGenerator.ignoreTypes.s";
    public static final String JSONSCHEMA_useBeanDefs = "JsonSchemaGenerator.useBeanDefs.b";
    public static final JsonSchemaGenerator DEFAULT = new JsonSchemaGenerator(PropertyStore.DEFAULT);
    private final boolean useBeanDefs;
    private final boolean allowNestedExamples;
    private final boolean allowNestedDescriptions;
    private final BeanDefMapper beanDefMapper;
    private final Set<TypeCategory> addExamplesTo;
    private final Set<TypeCategory> addDescriptionsTo;
    private final Map<String, OMap> defaultSchemas;
    private final JsonSerializer jsonSerializer;
    private final Set<Pattern> ignoreTypes;
    private final Map<ClassMeta<?>, JsonSchemaClassMeta> jsonSchemaClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, JsonSchemaBeanPropertyMeta> jsonSchemaBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, JsonSchemaBeanPropertyMeta>();

    public JsonSchemaGenerator(PropertyStore ps) {
        super(ps.builder().setDefault("BeanTraverseContext.detectRecursions.b", true).setDefault("BeanTraverseContext.ignoreRecursions.b", true).build());
        this.useBeanDefs = this.getBooleanProperty(JSONSCHEMA_useBeanDefs, false);
        this.allowNestedExamples = this.getBooleanProperty(JSONSCHEMA_allowNestedExamples, false);
        this.allowNestedDescriptions = this.getBooleanProperty(JSONSCHEMA_allowNestedDescriptions, false);
        this.beanDefMapper = this.getInstanceProperty(JSONSCHEMA_beanDefMapper, BeanDefMapper.class, BasicBeanDefMapper.class);
        this.addExamplesTo = TypeCategory.parse(this.getStringProperty(JSONSCHEMA_addExamplesTo, null));
        this.addDescriptionsTo = TypeCategory.parse(this.getStringProperty(JSONSCHEMA_addDescriptionsTo, null));
        this.defaultSchemas = this.getMapProperty(JSONSCHEMA_defaultSchemas, OMap.class);
        LinkedHashSet<Pattern> ignoreTypes = new LinkedHashSet<Pattern>();
        for (String s : StringUtils.split(ps.getProperty(JSONSCHEMA_ignoreTypes, String.class, ""))) {
            ignoreTypes.add(Pattern.compile(s.replace(".", "\\.").replace("*", ".*")));
        }
        this.ignoreTypes = ignoreTypes;
        this.jsonSerializer = new JsonSerializer(ps);
    }

    @Override
    public JsonSchemaGeneratorBuilder builder() {
        return new JsonSchemaGeneratorBuilder(this.getPropertyStore());
    }

    public static JsonSchemaGeneratorBuilder create() {
        return new JsonSchemaGeneratorBuilder();
    }

    @Override
    public JsonSchemaGeneratorSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public JsonSchemaGeneratorSession createSession(BeanSessionArgs args) {
        return new JsonSchemaGeneratorSession(this, args);
    }

    JsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    protected final Set<TypeCategory> getAddDescriptionsTo() {
        return this.addDescriptionsTo;
    }

    protected final Set<TypeCategory> getAddExamplesTo() {
        return this.addExamplesTo;
    }

    protected final boolean isAllowNestedDescriptions() {
        return this.allowNestedDescriptions;
    }

    protected final boolean isAllowNestedExamples() {
        return this.allowNestedExamples;
    }

    protected final BeanDefMapper getBeanDefMapper() {
        return this.beanDefMapper;
    }

    protected final Map<String, OMap> getDefaultSchemas() {
        return this.defaultSchemas;
    }

    public Set<Pattern> getIgnoreTypes() {
        return this.ignoreTypes;
    }

    protected final boolean isUseBeanDefs() {
        return this.useBeanDefs;
    }

    @Override
    public JsonSchemaClassMeta getJsonSchemaClassMeta(ClassMeta<?> cm) {
        JsonSchemaClassMeta m = this.jsonSchemaClassMetas.get(cm);
        if (m == null) {
            m = new JsonSchemaClassMeta(cm, this);
            this.jsonSchemaClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public JsonSchemaBeanPropertyMeta getJsonSchemaBeanPropertyMeta(BeanPropertyMeta bpm) {
        JsonSchemaBeanPropertyMeta m = this.jsonSchemaBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new JsonSchemaBeanPropertyMeta(bpm, this);
            this.jsonSchemaBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    public boolean isIgnoredType(ClassMeta<?> cm) {
        for (Pattern p : this.ignoreTypes) {
            if (!p.matcher(cm.getSimpleName()).matches() && !p.matcher(cm.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("useBeanDefs", this.useBeanDefs).a("allowNestedExamples", this.allowNestedExamples).a("allowNestedDescriptions", this.allowNestedDescriptions).a("beanDefMapper", this.beanDefMapper).a("addExamplesTo", this.addExamplesTo).a("addDescriptionsTo", this.addDescriptionsTo).a("defaultSchemas", this.defaultSchemas).a("ignoreTypes", this.ignoreTypes));
    }
}

