/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.Collection;
import java.util.List;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

@Command(scope="bundle", name="classes", description="Displays a list of classes/resources contained in the bundle")
public class Classes
extends BundlesCommand {
    @Option(name="-a", aliases={"--display-all-files"}, description="List all classes and files in the bundle", required=false, multiValued=false)
    boolean displayAllFiles;

    public Classes() {
        super(true);
    }

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        for (Bundle bundle : bundles) {
            this.printResources(bundle);
        }
    }

    protected void printResources(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            Collection resources = this.displayAllFiles ? wiring.listResources("/", null, 1) : wiring.listResources("/", "*class", 1);
            Collection localresources = this.displayAllFiles ? wiring.listResources("/", null, 3) : wiring.listResources("/", "*class", 3);
            for (String resource : resources) {
                if (localresources.contains(resource)) {
                    System.out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(resource).a(Ansi.Attribute.RESET));
                    continue;
                }
                System.out.println(resource);
            }
        } else {
            System.out.println("Bundle " + bundle.getBundleId() + " is not resolved.");
        }
    }
}

