/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.administrative;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.subtree.AdministrativeRole;
import org.apache.directory.server.core.api.administrative.AdministrativePoint;

public abstract class AbstractAdministrativePoint
implements AdministrativePoint {
    protected Dn dn;
    protected String uuid;
    protected AdministrativeRole role;
    protected AdministrativePoint parent;
    protected Map<String, AdministrativePoint> children;

    protected AbstractAdministrativePoint(Dn dn, String uuid, AdministrativeRole role) {
        this.dn = dn;
        this.uuid = uuid;
        this.role = role;
        this.children = new ConcurrentHashMap<String, AdministrativePoint>();
    }

    @Override
    public AdministrativeRole getRole() {
        return this.role;
    }

    @Override
    public Dn getDn() {
        return this.dn;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public boolean isAutonomous() {
        return false;
    }

    @Override
    public AdministrativePoint getParent() {
        return this.parent;
    }

    @Override
    public void setParent(AdministrativePoint parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Role: '").append(this.role).append("', ");
        sb.append("Dn: '").append(this.dn).append("', ");
        sb.append("UUID: ").append(this.uuid).append('\n');
        return sb.toString();
    }
}

