/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.services.token.state")
public interface TokenStateServiceMessages {
    @Message(level=MessageLevel.DEBUG, text="Added token {0}, expiration {1}")
    public void addedToken(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Renewed token {0}, expiration {1}")
    public void renewedToken(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Revoked token {0}")
    public void revokedToken(String var1);

    @Message(level=MessageLevel.DEBUG, text="Removed state for token {0}")
    public void removedTokenState(String var1);

    @Message(level=MessageLevel.ERROR, text="Unknown token {0}")
    public void unknownToken(String var1);

    @Message(level=MessageLevel.ERROR, text="The renewal limit for the token ({0}) has been exceeded.")
    public void renewalLimitExceeded(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to save state for token {0} : {1}")
    public void failedToSaveTokenState(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Error accessing state for token {0} : {1}")
    public void errorAccessingTokenState(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Referencing the expiration in the token ({0}) because no state could not be found: {1}")
    public void permissiveTokenHandling(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Failed to update expiration for token {1} : {1}")
    public void failedToUpdateTokenExpiration(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to remove state for token {0} : {1}")
    public void failedToRemoveTokenState(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to evict expired token {0} : {1}")
    public void failedExpiredTokenEviction(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Evicting expired token {0}")
    public void evictToken(String var1);

    @Message(level=MessageLevel.ERROR, text="Error occurred evicting token {0}")
    public void errorEvictingTokens(@StackTrace(level=MessageLevel.DEBUG) Exception var1);
}

