/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonHelper {
    private static final Logger logger = LoggerFactory.getLogger(JsonHelper.class);
    private static ObjectMapper mapper = new ObjectMapper();

    private JsonHelper() {
    }

    public static JsonNode getFirstNode(String text) {
        return JsonHelper.getFirstNode(text, null);
    }

    public static JsonNode getFirstNode(String text, String path) {
        try {
            JsonNode node = (JsonNode)mapper.readValue(text, JsonNode.class);
            if (path != null) {
                node = (JsonNode)JsonHelper.getElement(node, path);
            }
            return node;
        }
        catch (IOException e) {
            logger.error("Cannot get first node", (Throwable)e);
            return null;
        }
    }

    public static Object getElement(JsonNode json, String name) {
        if (json != null && name != null) {
            JsonNode node = json;
            for (String nodeName : name.split("\\.")) {
                if (node == null) continue;
                node = nodeName.matches("\\d+") ? node.get(Integer.parseInt(nodeName)) : node.get(nodeName);
            }
            if (node != null) {
                if (node.isNumber()) {
                    return node.numberValue();
                }
                if (node.isBoolean()) {
                    return node.booleanValue();
                }
                if (node.isTextual()) {
                    return node.textValue();
                }
                if (node.isNull()) {
                    return null;
                }
                return node;
            }
        }
        return null;
    }

    public static String toJSONString(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            logger.error("Cannot to JSON string", (Throwable)e);
            return null;
        }
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

