/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.metrics.impl.instr;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.knox.gateway.GatewayFilter;
import org.apache.knox.gateway.services.metrics.impl.instr.InstrUtils;

public class InstrumentedGatewayFilter
extends GatewayFilter {
    private GatewayFilter gatewayFilter;
    private MetricRegistry metricRegistry;

    public InstrumentedGatewayFilter(GatewayFilter gatewayFilter, MetricRegistry metricRegistry) {
        this.gatewayFilter = gatewayFilter;
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.gatewayFilter.init(filterConfig);
    }

    @Override
    public void destroy() {
        this.gatewayFilter.destroy();
    }

    @Override
    public void addFilter(String path, String name, Filter filter, Map<String, String> params, String resourceRole) throws URISyntaxException {
        this.gatewayFilter.addFilter(path, name, filter, params, resourceRole);
    }

    @Override
    public void addFilter(String path, String name, String clazz, Map<String, String> params, String resourceRole) throws URISyntaxException {
        this.gatewayFilter.addFilter(path, name, clazz, params, resourceRole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Timer.Context timerContext = this.timer(servletRequest).time();
        try {
            this.gatewayFilter.doFilter(servletRequest, servletResponse, filterChain);
        }
        finally {
            timerContext.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        Timer.Context timerContext = this.timer(servletRequest).time();
        try {
            this.gatewayFilter.doFilter(servletRequest, servletResponse);
        }
        finally {
            timerContext.stop();
        }
    }

    private Timer timer(ServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append("client.").append(request.getServletContext().getContextPath());
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            builder.append(InstrUtils.getResourcePath(httpServletRequest.getPathInfo()));
            builder.append('.');
            builder.append(httpServletRequest.getMethod());
            builder.append("-requests");
        }
        return this.metricRegistry.timer(builder.toString());
    }
}

