/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.annotations.OrderCorrection;
import org.eclipse.persistence.annotations.OrderCorrectionType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.DirectColumnMetadata;
import org.eclipse.persistence.mappings.CollectionMapping;

public class OrderColumnMetadata
extends DirectColumnMetadata {
    private static final String _ORDER = "_ORDER";
    private String m_correctionType;

    public OrderColumnMetadata() {
        super("<order-column>");
    }

    public OrderColumnMetadata(MetadataAnnotation orderColumn, MetadataAccessor accessor) {
        super(orderColumn, accessor);
        if (accessor.isAnnotationPresent(OrderCorrection.class)) {
            this.m_correctionType = accessor.getAnnotation(OrderCorrection.class).getAttributeString("value");
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof OrderColumnMetadata) {
            OrderColumnMetadata orderColumn = (OrderColumnMetadata)objectToCompare;
            return this.valuesMatch(this.m_correctionType, orderColumn.getCorrectionType());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_correctionType != null ? this.m_correctionType.hashCode() : 0);
        return result;
    }

    public String getCorrectionType() {
        return this.m_correctionType;
    }

    public void process(CollectionMapping mapping, MetadataDescriptor descriptor) {
        if (((MetadataAnnotatedElement)this.getAccessibleObject()).getRawClass(descriptor).isList()) {
            DatabaseField orderField = this.getDatabaseField();
            this.setFieldName(orderField, String.valueOf(mapping.getAttributeName()) + _ORDER, "metadata_default_order_column");
            mapping.setListOrderField(orderField);
            if (this.m_correctionType != null) {
                OrderCorrectionType[] values = OrderCorrectionType.values();
                int i = 0;
                while (i < values.length) {
                    if (values[i].name().equals(this.m_correctionType)) {
                        mapping.setOrderCorrectionType(values[i]);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            throw ValidationException.invalidAttributeTypeForOrderColumn(mapping.getAttributeName(), descriptor.getJavaClass());
        }
    }

    public void setCorrectionType(String correctionType) {
        this.m_correctionType = correctionType;
    }
}

