/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.commands;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.knox.gateway.shell.CredentialCollector;
import org.apache.knox.gateway.shell.KnoxDataSource;
import org.apache.knox.gateway.shell.commands.AbstractSQLCommandSupport;
import org.apache.knox.gateway.shell.commands.SwingUtils;
import org.apache.knox.gateway.shell.table.KnoxShellTable;
import org.codehaus.groovy.tools.shell.Groovysh;

public class SelectCommand
extends AbstractSQLCommandSupport
implements KeyListener {
    private static final String USAGE = ":sql [assign resulting-variable-name]";
    private static final String DESC = "Build table from SQL ResultSet";
    private static final String KNOXDATASOURCE = "__knoxdatasource";
    private JTextArea sqlField;
    private List<String> sqlHistory;
    private int historyIndex = -1;

    public SelectCommand(Groovysh shell) {
        super(shell, ":SQL", ":sql", DESC, USAGE, DESC);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        int code = event.getKeyCode();
        boolean setFromHistory = false;
        if (this.sqlHistory != null && !this.sqlHistory.isEmpty()) {
            if (this.historyIndex == -1) {
                this.historyIndex = this.sqlHistory.size() + 1;
            }
            if (code == 224 || code == 38) {
                if (this.historyIndex > 0) {
                    --this.historyIndex;
                }
                setFromHistory = true;
            } else if ((code == 225 || code == 40) && this.historyIndex < this.sqlHistory.size() - 1) {
                ++this.historyIndex;
                setFromHistory = true;
            }
            if (setFromHistory) {
                this.sqlField.setText(this.sqlHistory.get(this.historyIndex));
                this.sqlField.invalidate();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public Object execute(List<String> args) {
        KnoxShellTable table;
        String bindVariableName;
        block39: {
            boolean ok = false;
            String sql = "";
            bindVariableName = null;
            table = null;
            if (!args.isEmpty()) {
                bindVariableName = this.getBindingVariableNameForResultingTable(args);
            }
            String dsName = (String)this.getVariables().get(KNOXDATASOURCE);
            Map<String, KnoxDataSource> dataSources = this.getDataSources();
            KnoxDataSource ds = null;
            if (dsName == null || dsName.isEmpty()) {
                if (dataSources == null || dataSources.isEmpty()) {
                    return "please configure a datasource with ':datasources add {name} {connectStr} {driver} {authntype: none|basic}'.";
                }
                if (dataSources.size() == 1) {
                    dsName = (String)dataSources.keySet().toArray()[0];
                } else {
                    return "mulitple datasources configured. please disambiguate with ':datasources select {name}'.";
                }
            }
            this.sqlHistory = this.getSQLHistory(dsName);
            this.historyIndex = this.sqlHistory != null && !this.sqlHistory.isEmpty() ? this.sqlHistory.size() - 1 : -1;
            ds = dataSources.get(dsName);
            if (ds != null) {
                JLabel jl = new JLabel("Query: ");
                this.sqlField = new JTextArea(5, 40);
                this.sqlField.addKeyListener(this);
                this.sqlField.setLineWrap(true);
                JScrollPane scrollPane = new JScrollPane(this.sqlField);
                Box box = Box.createHorizontalBox();
                box.add(jl);
                box.add(scrollPane);
                SwingUtils.workAroundFocusIssue(this.sqlField);
                int x = JOptionPane.showConfirmDialog(null, box, "SQL Query Input", 2);
                if (x == 0) {
                    ok = true;
                    sql = this.sqlField.getText();
                    this.addToSQLHistory(dsName, sql);
                    this.historyIndex = -1;
                }
                try {
                    if (!ok) break block39;
                    System.out.println(sql);
                    try {
                        Connection conn = this.getConnectionFromSession(ds);
                        if (conn == null || conn.isClosed()) {
                            String username = null;
                            char[] pass = null;
                            if (ds.getAuthnType().equalsIgnoreCase("basic")) {
                                CredentialCollector dlg = this.login();
                                username = dlg.name();
                                pass = dlg.chars();
                            }
                            conn = this.getConnection(ds, username, new String(pass));
                        }
                        try (Statement statement = conn.createStatement();){
                            if (!statement.execute(sql)) break block39;
                            try (ResultSet resultSet = statement.getResultSet();){
                                table = KnoxShellTable.builder().jdbc().resultSet(resultSet);
                            }
                        }
                    }
                    catch (SQLException e) {
                        System.out.println("SQL Exception encountered... " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                return "please select a datasource via ':datasources select {name}'.";
            }
        }
        if (table != null && bindVariableName != null) {
            this.getVariables().put(bindVariableName, table);
        }
        return table;
    }
}

