/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.entry;

public enum ModificationOperation {
    ADD_ATTRIBUTE(0),
    REMOVE_ATTRIBUTE(1),
    REPLACE_ATTRIBUTE(2),
    INCREMENT_ATTRIBUTE(3);

    private int value;

    private ModificationOperation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ModificationOperation getOperation(int value) {
        if (value == ModificationOperation.ADD_ATTRIBUTE.value) {
            return ADD_ATTRIBUTE;
        }
        if (value == ModificationOperation.REMOVE_ATTRIBUTE.value) {
            return REMOVE_ATTRIBUTE;
        }
        if (value == ModificationOperation.REPLACE_ATTRIBUTE.value) {
            return REPLACE_ATTRIBUTE;
        }
        if (value == ModificationOperation.INCREMENT_ATTRIBUTE.value) {
            return INCREMENT_ATTRIBUTE;
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case ADD_ATTRIBUTE: {
                return "add";
            }
            case REPLACE_ATTRIBUTE: {
                return "replace";
            }
            case REMOVE_ATTRIBUTE: {
                return "remove";
            }
            case INCREMENT_ATTRIBUTE: {
                return "increment";
            }
        }
        return "";
    }
}

